/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.subscription;

import c8y.ua.data.SubscriptionParameters;
import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.OpcuaClient;
import com.cumulocity.opcua.client.exception.OpcuaClientException;
import com.cumulocity.opcua.client.exception.SubscriptionNotFoundException;
import com.cumulocity.opcua.client.gateway.ServerIdentifier;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.exception.ServerNotConnectedException;
import com.cumulocity.opcua.client.gateway.mappings.model.DataMappingParameters;
import com.cumulocity.opcua.client.gateway.mappings.model.EventMappingParameters;
import com.cumulocity.opcua.client.gateway.platform.repository.AlarmRepository;
import com.cumulocity.opcua.client.gateway.subscription.SubscriptionService;
import com.cumulocity.opcua.client.gateway.subscription.UaSubscriptionService;
import com.cumulocity.opcua.client.gateway.subscription.model.BaseSubscriptionData;
import com.cumulocity.opcua.client.gateway.subscription.model.EventSubscribedItem;
import com.cumulocity.opcua.client.gateway.subscription.model.NodeEventTypeId;
import com.cumulocity.opcua.client.gateway.subscription.model.SubscribedItem;
import com.cumulocity.opcua.client.gateway.subscription.model.SubscribedItemId;
import com.cumulocity.opcua.client.gateway.subscription.model.SubscriptionData;
import com.cumulocity.opcua.client.gateway.subscription.model.SubscriptionEventData;
import com.cumulocity.opcua.client.gateway.subscription.repository.SubscriptionRepository;
import com.cumulocity.opcua.client.listener.OpcuaSubscriptionNotificationListener;
import com.cumulocity.opcua.client.model.MonitoredDataItemConfig;
import com.cumulocity.opcua.client.model.MonitoredEventItemConfig;
import com.cumulocity.opcua.client.model.MonitoredItemConfig;
import com.cumulocity.opcua.client.model.SubscriptionConfig;
import com.cumulocity.opcua.client.model.SubscriptionResult;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.DataChangeTrigger;
import com.prosysopc.ua.stack.core.DeadbandType;
import com.prosysopc.ua.stack.core.MonitoringMode;
import com.prosysopc.ua.stack.utils.NumericRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Primary;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="uaSubscriptionService")
@Primary
public class UaSubscriptionService
implements SubscriptionService {
    private static final Logger log = LoggerFactory.getLogger(UaSubscriptionService.class);
    private static final String SERVER_SUBSCRIPTION_ERROR_ALARM_SEVERITY = "MAJOR";
    private static final Double RELATIVE_ALIVENESS_RATIO = 1.5;
    @Value(value="${gateway.subscription.reportingRate:100}")
    private Long reportingRate;
    @Value(value="${gateway.subscription.maxKeepAliveCount:200}")
    private Long maxKeepAliveCount;
    @Value(value="${gateway.subscription.lifetimeCount:600}")
    private Long lifetimeCount;
    @Value(value="${gateway.subscription.notificationBufferSize:500}")
    private Integer notificationBufferSize;
    @Value(value="${gateway.subscription.recreateFailedItems:false}")
    private Boolean recreateFailedItems;
    @Autowired
    private ConnectionManager connectionManager;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private AlarmRepository alarmRepository;
    @Autowired
    private SubscriptionRepository subscriptionRepository;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    public void applySubscriptions(String serverId, BaseSubscriptionData subscriptionData) throws OpcuaClientException, ServerNotConnectedException {
        this.applySubscriptions(serverId, subscriptionData, 2);
    }

    public void removeSubscriptions(String serverId, String deviceTypeId, String rootNodeId) {
        Optional serverSubscriptionId = this.subscriptionRepository.getServerSubscriptionId(serverId);
        Collection matchingItems = this.subscriptionRepository.removeSubscribedNode(serverId, deviceTypeId, rootNodeId, this.getSubscriptionType());
        serverSubscriptionId.ifPresent(unsignedInteger -> this.removeMatchingItems(serverId, unsignedInteger, matchingItems));
        Optional updatedServerSubscriptionId = this.subscriptionRepository.getServerSubscriptionId(serverId);
        if (serverSubscriptionId.isPresent() && !updatedServerSubscriptionId.isPresent()) {
            this.unsubscribe(serverId, (UnsignedInteger)serverSubscriptionId.get());
        }
    }

    public void removeSubscriptions(String serverId, Collection<String> deviceTypeIds) {
        Optional serverSubscriptionId = this.subscriptionRepository.getServerSubscriptionId(serverId);
        Collection matchingItems = this.subscriptionRepository.removeSubscribedItemsForDeviceTypes(serverId, deviceTypeIds, this.getSubscriptionType());
        serverSubscriptionId.ifPresent(unsignedInteger -> this.removeMatchingItems(serverId, unsignedInteger, matchingItems));
        Optional updatedServerSubscriptionId = this.subscriptionRepository.getServerSubscriptionId(serverId);
        if (serverSubscriptionId.isPresent() && !updatedServerSubscriptionId.isPresent()) {
            this.unsubscribe(serverId, (UnsignedInteger)serverSubscriptionId.get());
        }
    }

    public void removeServerSubscriptions(String serverId) {
        Optional subscriptionId = this.subscriptionRepository.removeServerSubscriptions(serverId, this.getSubscriptionType());
        if (!subscriptionId.isPresent()) {
            return;
        }
        this.unsubscribe(serverId, (UnsignedInteger)subscriptionId.get());
    }

    public String getSubscriptionType() {
        return "Subscription";
    }

    private void applySubscriptions(String serverId, BaseSubscriptionData subscriptionData, int retries) throws OpcuaClientException, ServerNotConnectedException {
        Optional clientOptional = this.connectionManager.getConnection(new ServerIdentifier(GId.asGId((String)serverId)));
        if (!clientOptional.isPresent()) {
            throw new ServerNotConnectedException("Server not connected: " + serverId);
        }
        OpcuaClient client = (OpcuaClient)clientOptional.get();
        List itemConfigs = this.getDataItemConfigs(subscriptionData);
        if (CollectionUtils.isEmpty((Collection)itemConfigs)) {
            log.warn("Empty subscription config data");
            return;
        }
        Optional serverSubscription = this.subscriptionRepository.getServerSubscriptionId(serverId);
        if (serverSubscription.isPresent()) {
            try {
                this.addMonitoredItems(client, (UnsignedInteger)serverSubscription.get(), serverId, itemConfigs, subscriptionData);
            }
            catch (SubscriptionNotFoundException e) {
                log.error("Subscription was not found, removing it from subscription list", (Throwable)e);
                this.subscriptionRepository.removeServerSubscriptions(serverId, this.getSubscriptionType());
                if (retries <= 0) {
                    throw e;
                }
                log.warn("Retrying to subscribe, number of retries left: {}", (Object)retries);
                this.applySubscriptions(serverId, subscriptionData, --retries);
            }
        } else {
            boolean serverSubscriptionExisted = this.createServerSubscription(client, subscriptionData, serverId, itemConfigs);
            if (serverSubscriptionExisted) {
                serverSubscription = this.subscriptionRepository.getServerSubscriptionId(serverId);
                this.addMonitoredItems(client, (UnsignedInteger)serverSubscription.get(), serverId, itemConfigs, subscriptionData);
            }
        }
    }

    private void unsubscribe(String serverId, UnsignedInteger subscriptionId) {
        Optional clientOptional = this.connectionManager.getConnection(new ServerIdentifier(GId.asGId((String)serverId)));
        if (!clientOptional.isPresent()) {
            log.warn("Not connected to server, skip removing subscription");
            return;
        }
        try {
            ((OpcuaClient)clientOptional.get()).unsubscribe(subscriptionId);
        }
        catch (OpcuaClientException e) {
            log.warn("Unable to remove subscription on server disconnection: {}/{}", new Object[]{serverId, subscriptionId, e});
        }
    }

    private void removeMatchingItems(String serverId, UnsignedInteger subscriptionId, Collection<SubscribedItem> matchingItems) {
        Optional clientOptional = this.connectionManager.getConnection(new ServerIdentifier(GId.asGId((String)serverId)));
        if (!clientOptional.isPresent()) {
            log.warn("Server not connected: {}, skip removing monitored items", (Object)serverId);
            return;
        }
        OpcuaClient client = (OpcuaClient)clientOptional.get();
        this.removeMonitoredItems(subscriptionId, client, matchingItems);
    }

    private void removeMonitoredItems(UnsignedInteger serverSubscription, OpcuaClient client, Collection<SubscribedItem> matchingItems) {
        if (!CollectionUtils.isEmpty(matchingItems)) {
            List monitoredItems = matchingItems.stream().filter(item -> Objects.nonNull(item.getMonitoredItemId())).map(SubscribedItem::getSubscribedItemId).map(SubscribedItemId::getMonitoredItemId).collect(Collectors.toList());
            log.info("Removing monitorGatewayInstance items from server subscription {}: {}", (Object)serverSubscription, monitoredItems);
            try {
                client.removeMonitoredDataItems(serverSubscription, monitoredItems);
            }
            catch (OpcuaClientException e) {
                log.error("Unable to remove monitored items", (Throwable)e);
            }
        }
    }

    private void addMonitoredItems(OpcuaClient client, UnsignedInteger subscriptionId, String serverId, List<MonitoredItemConfig> itemConfigs, BaseSubscriptionData subscriptionData) throws OpcuaClientException {
        log.info("Adding monitored item(s): {} to server subscription {}/{}", new Object[]{itemConfigs, serverId, subscriptionId});
        List itemIds = client.addMonitoredItems(subscriptionId, itemConfigs);
        log.info("Added monitored item(s): {}", (Object)itemIds);
        this.addSubscribedItems(subscriptionId, serverId, itemConfigs, subscriptionData, itemIds);
    }

    private synchronized boolean createServerSubscription(OpcuaClient client, BaseSubscriptionData subscriptionData, String serverId, List<MonitoredItemConfig> itemConfigs) throws OpcuaClientException {
        Optional serverSubscription = this.subscriptionRepository.getServerSubscriptionId(serverId);
        if (serverSubscription.isPresent()) {
            return true;
        }
        log.info("Creating new subscription: {} for server: {}", (Object)subscriptionData, (Object)serverId);
        SubscriptionConfig subscriptionConfig = SubscriptionConfig.builder().mode(MonitoringMode.Reporting).publishingIntervalMils(this.reportingRate).keepAliveCount(this.maxKeepAliveCount).lifetimeCount(this.lifetimeCount).notificationBufferSize(this.notificationBufferSize).recreateFailedItems(this.recreateFailedItems).subscriptions(itemConfigs).build();
        SubscriptionNotificationListenerImpl subscriptionListener = new SubscriptionNotificationListenerImpl(this, serverId, this.eventPublisher, this.alarmRepository);
        SubscriptionResult subscriptionResult = client.subscribe(subscriptionConfig, (OpcuaSubscriptionNotificationListener)subscriptionListener);
        log.info("Subscription result: {}", (Object)subscriptionResult);
        this.addSubscribedItems(subscriptionResult.getSubscriptionId(), serverId, itemConfigs, subscriptionData, subscriptionResult.getItemIds());
        subscriptionListener.startMonitor();
        return false;
    }

    private void addSubscribedItems(UnsignedInteger subscriptionId, String serverId, List<MonitoredItemConfig> itemConfigs, BaseSubscriptionData subscriptionData, List<UnsignedInteger> itemIds) {
        ArrayList subscribedItems = new ArrayList();
        for (int i = 0; i < itemIds.size(); ++i) {
            UnsignedInteger itemId = itemIds.get(i);
            MonitoredItemConfig itemConfig = itemConfigs.get(i);
            String targetNodeId = itemConfig.getNodeId();
            if (subscriptionData instanceof SubscriptionData) {
                this.addSubscribedDataItem(subscriptionId, serverId, (SubscriptionData)subscriptionData, subscribedItems, itemId, targetNodeId);
            } else if (subscriptionData instanceof SubscriptionEventData && itemConfig instanceof MonitoredEventItemConfig) {
                this.addSubscribedEventItem(subscriptionId, serverId, (SubscriptionEventData)subscriptionData, subscribedItems, itemId, (MonitoredEventItemConfig)itemConfig, targetNodeId);
            } else {
                log.warn("Monitored items does not match with subscription data, subscription data: {}, itemConfigs: {}, itemIds: {}, itemConfig: {}, itemId: {}", new Object[]{subscriptionData, itemConfigs, itemIds, itemConfig, itemId});
            }
            this.subscriptionRepository.addSubscribedItems(subscribedItems);
        }
    }

    private void addSubscribedDataItem(UnsignedInteger subscriptionId, String serverId, SubscriptionData subscriptionData, Collection<SubscribedItem> subscribedItems, UnsignedInteger itemId, String targetNodeId) {
        Collection mappingActions = ((DataMappingParameters)subscriptionData.getNodeSubscriptions().get(targetNodeId)).getMappingActions();
        if (Objects.nonNull(mappingActions)) {
            SubscribedItem subscribedItem = SubscribedItem.builder().deviceTypeId(subscriptionData.getDeviceTypeId()).rootNodeId(subscriptionData.getRootNodeId()).subscriptionType(this.getSubscriptionType()).subscribedItemId(new SubscribedItemId(serverId, targetNodeId, itemId)).subscriptionId(subscriptionId).mappedActions(mappingActions).build();
            subscribedItems.add(subscribedItem);
        }
    }

    private void addSubscribedEventItem(UnsignedInteger subscriptionId, String serverId, SubscriptionEventData subscriptionEventData, Collection<SubscribedItem> subscribedItems, UnsignedInteger itemId, MonitoredEventItemConfig itemConfig, String targetNodeId) {
        NodeEventTypeId nodeEventTypeId = new NodeEventTypeId(itemConfig.getNodeId(), itemConfig.getEventTypeId());
        EventMappingParameters eventParameters = (EventMappingParameters)subscriptionEventData.getEventSubscriptions().get(nodeEventTypeId);
        Collection mappingActions = eventParameters.getMappingActions();
        if (Objects.nonNull(mappingActions)) {
            EventSubscribedItem subscribedItem = EventSubscribedItem.eventBuilder().deviceTypeId(subscriptionEventData.getDeviceTypeId()).rootNodeId(subscriptionEventData.getRootNodeId()).subscriptionType(this.getSubscriptionType()).subscribedItemId(new SubscribedItemId(serverId, targetNodeId, itemId)).subscriptionId(subscriptionId).mappedActions(mappingActions).attributes(eventParameters.getAttributes()).build();
            subscribedItems.add((SubscribedItem)subscribedItem);
        }
    }

    private List<MonitoredItemConfig> getDataItemConfigs(BaseSubscriptionData subscriptionData) throws OpcuaClientException {
        ArrayList<MonitoredItemConfig> itemConfigs;
        block3: {
            block2: {
                itemConfigs = new ArrayList<MonitoredItemConfig>();
                if (!(subscriptionData instanceof SubscriptionData)) break block2;
                for (Map.Entry entry : ((SubscriptionData)subscriptionData).getNodeSubscriptions().entrySet()) {
                    if (!this.isValidSubscriptionType((DataMappingParameters)entry.getValue())) continue;
                    MonitoredDataItemConfig itemConfig = this.buildDataItemConfig((String)entry.getKey(), ((DataMappingParameters)entry.getValue()).getSubscriptionConfig().getSubscriptionParameters());
                    itemConfigs.add((MonitoredItemConfig)itemConfig);
                }
                break block3;
            }
            if (!(subscriptionData instanceof SubscriptionEventData)) break block3;
            for (Map.Entry entry : ((SubscriptionEventData)subscriptionData).getEventSubscriptions().entrySet()) {
                MonitoredEventItemConfig itemConfig = this.buildEventItemConfig((NodeEventTypeId)entry.getKey(), ((EventMappingParameters)entry.getValue()).getAttributes());
                itemConfigs.add((MonitoredItemConfig)itemConfig);
            }
        }
        return itemConfigs;
    }

    private MonitoredDataItemConfig buildDataItemConfig(String nodeId, SubscriptionParameters parameters) throws OpcuaClientException {
        MonitoredDataItemConfig.MonitoredDataItemConfigBuilder builder = MonitoredDataItemConfig.builder().nodeId(nodeId).queueSize(parameters.getQueueSize()).samplingIntervalMils(parameters.getSamplingRate());
        if (!Objects.isNull(parameters.getDeadbandType()) && !Objects.isNull(parameters.getDeadbandValue())) {
            builder = builder.deadbandType(DeadbandType.valueOf((String)parameters.getDeadbandType())).deadbandValue(parameters.getDeadbandValue());
        }
        if (Objects.nonNull(parameters.getDataChangeTrigger())) {
            builder = builder.dataChangeTrigger(DataChangeTrigger.valueOf((String)parameters.getDataChangeTrigger()));
        }
        builder = Objects.nonNull(parameters.getDiscardOldest()) ? builder.discardOldest(parameters.getDiscardOldest().booleanValue()) : builder.discardOldest(true);
        if (!StringUtils.isEmpty((Object)parameters.getRanges())) {
            try {
                builder = builder.ranges(NumericRange.parse((String)parameters.getRanges()));
            }
            catch (ServiceResultException e) {
                throw new OpcuaClientException("Unexpected index ranges: " + parameters.getRanges());
            }
        }
        return builder.build();
    }

    private MonitoredEventItemConfig buildEventItemConfig(NodeEventTypeId nodeEventTypeId, List<String> attributes) {
        return MonitoredEventItemConfig.builder().nodeId(nodeEventTypeId.getNodeId()).eventTypeId(nodeEventTypeId.getEventTypeId()).eventAttributes(attributes).build();
    }

    private boolean isValidSubscriptionType(DataMappingParameters mappingParameters) {
        return Objects.nonNull(mappingParameters.getSubscriptionConfig()) && "Subscription".equalsIgnoreCase(mappingParameters.getSubscriptionConfig().getType()) && mappingParameters.getSubscriptionConfig().isValid();
    }
}

