/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.platform.repository;

import com.cumulocity.opcua.client.gateway.configuration.InventoryUpdateProcessingModeConfiguration;
import com.cumulocity.opcua.client.gateway.platform.repository.interceptor.ProcessingModeContext;
import com.cumulocity.opcua.common.repository.InventoryRepositoryImpl;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.cumulocity.sdk.client.ProcessingMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;

@Repository(value="pmAwareInventoryRepository")
@Primary
public class ProcessingModeAwareInventoryRepository
extends InventoryRepositoryImpl {
    @Autowired
    private InventoryUpdateProcessingModeConfiguration processingModeConfiguration;
    @Autowired
    private ProcessingModeContext processingModeContext;

    public ManagedObjectRepresentation update(ManagedObjectRepresentation managedObject, ProcessingMode processingMode) {
        return (ManagedObjectRepresentation)this.processingModeContext.callInPMContext(processingMode, () -> this.inventoryApi.update(managedObject));
    }

    public ManagedObjectRepresentation update(ManagedObjectRepresentation managedObject) {
        return (ManagedObjectRepresentation)this.processingModeContext.callInPMContext(this.processingModeConfiguration.getDefaultUpdateProcessingMode(), () -> this.inventoryApi.update(managedObject));
    }
}

