/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.platform.repository;

import c8y.ua.data.DeviceTypeMappedNodeCollection;
import com.cumulocity.opcua.client.gateway.datastore.GatewayLocalDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class MappedNodesRepository {
    private static final Logger log = LoggerFactory.getLogger(MappedNodesRepository.class);
    @Autowired
    public GatewayLocalDatabase db;

    public DeviceTypeMappedNodeCollection get(String serverId) {
        return this.db.getDeviceTypeMapping(serverId).orElse(null);
    }

    public void update(String serverId, DeviceTypeMappedNodeCollection deviceTypeMappedNodeCollection) {
        this.create(serverId, deviceTypeMappedNodeCollection);
    }

    public void create(String serverId, DeviceTypeMappedNodeCollection deviceTypeMappedNodeCollection) {
        this.db.addDeviceTypeMapping(serverId, deviceTypeMappedNodeCollection);
    }

    public void delete(String serverId) {
        this.db.removeDeviceTypeMapping(serverId);
    }

    @Autowired
    public MappedNodesRepository() {
    }

    public void setDb(GatewayLocalDatabase db) {
        this.db = db;
    }
}

