/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.platform.configuration;

import com.cumulocity.opcua.client.gateway.platform.model.PlatformConfiguredEvent;
import com.cumulocity.opcua.client.gateway.platform.model.PlatformConnectionReadyEvent;
import com.cumulocity.rest.representation.CumulocityMediaType;
import com.cumulocity.sdk.client.Platform;
import jakarta.ws.rs.core.Response;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class PlatformProvider {
    private static final Logger log = LoggerFactory.getLogger(PlatformProvider.class);
    @Value(value="${gateway.platform.platformAvailCheckRetryDelay:10000}")
    private Integer platformAvailCheckRetryDelay = 10000;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    protected final String inventoryResource = "/inventory";
    private Platform platform;

    public Platform get() {
        if (!this.isCredentialsAvailable()) {
            throw new IllegalStateException("Credentials are not available yet.");
        }
        return this.platform;
    }

    public boolean isCredentialsAvailable() {
        return this.platform != null;
    }

    @EventListener(value={PlatformConfiguredEvent.class})
    public void onPlatformConfigured(PlatformConfiguredEvent platformConfiguredEvent) throws InterruptedException {
        if (Objects.nonNull(platformConfiguredEvent.getPlatform())) {
            this.platform = platformConfiguredEvent.getPlatform();
        }
        if (!this.isPlatformAvailable()) {
            log.warn("Platform currently does not seem to be reachable at {}. ", (Object)"/inventory");
            TimeUnit.MILLISECONDS.sleep(this.platformAvailCheckRetryDelay.intValue());
            this.eventPublisher.publishEvent((Object)platformConfiguredEvent);
        } else {
            log.info("Platform is up!");
            this.eventPublisher.publishEvent((Object)new PlatformConnectionReadyEvent(platformConfiguredEvent.getUserName()));
        }
    }

    protected boolean isPlatformAvailable() {
        if (Objects.isNull(this.platform)) {
            return false;
        }
        try {
            Response.Status status = this.platform.rest().getStatus("/inventory", new CumulocityMediaType());
            return status.equals((Object)Response.Status.OK);
        }
        catch (Exception e) {
            log.warn("Error caught when checking platform availability: {}", (Object)e.getMessage());
            log.debug("Full stack exception : {}", (Throwable)e);
            return false;
        }
    }

    public void setPlatformAvailCheckRetryDelay(Integer platformAvailCheckRetryDelay) {
        this.platformAvailCheckRetryDelay = platformAvailCheckRetryDelay;
    }

    void setPlatform(Platform platform) {
        this.platform = platform;
    }
}

