/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.operation.handler.base;

import c8y.ua.Node;
import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.NodeIds;
import com.cumulocity.opcua.client.gateway.addressspace.service.AddressSpaceDataStoreService;
import com.cumulocity.opcua.client.gateway.configuration.GatewayGeneralConfiguration;
import com.cumulocity.opcua.client.gateway.platform.repository.AlarmRepository;
import com.cumulocity.opcua.common.DeviceExternalId;
import com.cumulocity.rest.representation.identity.ExternalIDRepresentation;
import com.cumulocity.sdk.client.QueryParam;
import com.cumulocity.sdk.client.identity.ExternalIDCollection;
import com.cumulocity.sdk.client.identity.IdentityApi;
import com.cumulocity.sdk.client.identity.PagedExternalIDCollectionRepresentation;
import com.prosysopc.ua.stack.common.NamespaceTable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class UAOperationNodeValidator {
    private static final Logger log = LoggerFactory.getLogger(UAOperationNodeValidator.class);
    protected final IdentityApi identityApi;
    protected final AlarmRepository alarmRepository;
    protected final AddressSpaceDataStoreService addressSpaceDataStoreService;
    protected final GatewayGeneralConfiguration gatewayConfiguration;

    public UAOperationNodeValidator(IdentityApi identityApi, AlarmRepository alarmRepository, AddressSpaceDataStoreService addressSpaceDataStoreService, GatewayGeneralConfiguration gatewayConfiguration) {
        this.identityApi = identityApi;
        this.alarmRepository = alarmRepository;
        this.addressSpaceDataStoreService = addressSpaceDataStoreService;
        this.gatewayConfiguration = gatewayConfiguration;
    }

    @Async
    public void validateNodes(Set<String> operationNodeIds, GId operationDeviceId, String serverId, NamespaceTable namespaceTable) {
        if (!this.gatewayConfiguration.isValidateDeviceOperationNodes()) {
            log.debug("Validation of operation nodes is disabled!");
            return;
        }
        if (operationNodeIds == null || operationNodeIds.isEmpty() || operationDeviceId == null || serverId == null) {
            log.debug("No operation nodes to validate!");
            return;
        }
        Optional rootNodeId = this.getRootNodeId(operationDeviceId);
        if (rootNodeId.isEmpty()) {
            log.warn("No root node found for opc ua device in external id: " + operationDeviceId.getValue());
            return;
        }
        Set operationNodeIdsWithNsu = this.convertOperationNodeIds(operationNodeIds, namespaceTable);
        log.debug("rootNodeId: " + (String)rootNodeId.get());
        for (String nodeId : operationNodeIdsWithNsu) {
            try {
                boolean isAncestor = this.isAncestorOf((String)rootNodeId.get(), nodeId, serverId);
                if (isAncestor) continue;
                String warnMessage = String.format("Node: %s is not a child of Root-Node: %s", nodeId, rootNodeId);
                log.warn(warnMessage);
                this.alarmRepository.create(operationDeviceId, "c8y_OPCUAOperationNotAncestorNode_" + nodeId, "WARNING", warnMessage);
                return;
            }
            catch (Exception e) {
                log.error((String)rootNodeId.get(), (Throwable)e);
            }
        }
    }

    public boolean isValidateDeviceOperationNodes() {
        return this.gatewayConfiguration.isValidateDeviceOperationNodes();
    }

    protected boolean isAncestorOf(String rootNodeId, String nodeId, String serverId) {
        if (rootNodeId.equals(nodeId)) {
            return true;
        }
        Optional nodeList = this.addressSpaceDataStoreService.fetchFromDataStore(serverId);
        if (!nodeList.isPresent()) {
            log.warn("No address space stored for OPC UA Server: " + serverId);
            return false;
        }
        for (Node node : (List)nodeList.get()) {
            if (!node.getNodeId().equals(nodeId)) continue;
            for (List ancestorNodeList : node.getAncestorNodeIds()) {
                if (!ancestorNodeList.contains(rootNodeId)) continue;
                return true;
            }
        }
        return false;
    }

    protected Optional<String> getRootNodeId(GId operationDeviceId) {
        ExternalIDRepresentation externalIdRepresentation = this.getOPCUADeviceExternalIdRepresentation(operationDeviceId);
        if (externalIdRepresentation == null || externalIdRepresentation.getExternalId() == null) {
            log.warn("No c8y_OpcuaDevice external id found for device: " + operationDeviceId.getValue());
            return Optional.empty();
        }
        try {
            DeviceExternalId deviceExternalId = new DeviceExternalId(externalIdRepresentation.getExternalId());
            return Optional.ofNullable(deviceExternalId.getNodeId());
        }
        catch (Exception e) {
            log.error("Error while parsing external id: " + externalIdRepresentation.getExternalId(), (Throwable)e);
            return Optional.empty();
        }
    }

    protected ExternalIDRepresentation getOPCUADeviceExternalIdRepresentation(GId operationDeviceId) {
        ExternalIDCollection externalIDCollection = this.identityApi.getExternalIdsOfGlobalId(operationDeviceId);
        PagedExternalIDCollectionRepresentation pagedExternalIDCollectionRepresentation = (PagedExternalIDCollectionRepresentation)externalIDCollection.get(new QueryParam[0]);
        return pagedExternalIDCollectionRepresentation.getExternalIds().stream().filter(externalID -> externalID.getType().equals("c8y_OpcuaDevice")).findFirst().orElse(null);
    }

    protected Set<String> convertOperationNodeIds(Set<String> operationNodeIds, NamespaceTable namespaceTable) {
        if (operationNodeIds == null || operationNodeIds.isEmpty()) {
            return operationNodeIds;
        }
        return operationNodeIds.stream().map(nodeId -> {
            int index = nodeId.lastIndexOf("nsu=");
            if (index == -1) {
                return NodeIds.toNodeIdWithNsUri((NamespaceTable)namespaceTable, (String)nodeId);
            }
            return nodeId;
        }).collect(Collectors.toSet());
    }
}

