/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.operation.handler.base;

import c8y.Command;
import c8y.ua.command.BaseOperation;
import com.cumulocity.opcua.client.OpcuaClient;
import com.cumulocity.opcua.client.exception.OpcuaClientException;
import com.cumulocity.opcua.client.gateway.GatewayManager;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.operation.exception.OperationExecutionException;
import com.cumulocity.opcua.client.gateway.operation.handler.base.HandleInternalResult;
import com.cumulocity.opcua.client.gateway.operation.handler.base.UAOperationHandler;
import com.cumulocity.opcua.client.gateway.operation.handler.base.UAOperationNodeValidator;
import com.cumulocity.opcua.client.model.WriteData;
import com.cumulocity.opcua.client.serialization.OpcuaSerializer;
import com.cumulocity.sdk.client.devicecontrol.DeviceControlApi;
import com.cumulocity.sdk.client.inventory.InventoryApi;
import com.prosysopc.ua.stack.core.WriteResponse;
import java.util.Optional;

public abstract class BaseWriteOperationHandler<T extends BaseOperation>
extends UAOperationHandler<T> {
    protected final OpcuaSerializer serializer;

    public BaseWriteOperationHandler(GatewayManager gatewayManager, ConnectionManager connectionManager, Class<T> supportedOperationType, DeviceControlApi deviceControlApi, OpcuaSerializer serializer, InventoryApi inventoryApi, UAOperationNodeValidator nodeValidator) {
        super(gatewayManager, connectionManager, supportedOperationType, deviceControlApi, inventoryApi, nodeValidator);
        this.serializer = serializer;
    }

    protected HandleInternalResult handleInternal(T operation) throws OperationExecutionException {
        Optional clientOptional = this.resolveClient(operation);
        if (!clientOptional.isPresent()) {
            throw new OperationExecutionException("UA Server is not resolvable / not connected!");
        }
        OpcuaClient client = (OpcuaClient)clientOptional.get();
        try {
            WriteResponse response = client.write(this.getWriteData(operation));
            Command command = new Command();
            command.setResult(this.serializer.toJson((Object)response));
            return new HandleInternalResult(command, true, null);
        }
        catch (OpcuaClientException e) {
            throw new OperationExecutionException((Throwable)e);
        }
    }

    protected abstract WriteData getWriteData(T var1);
}

