/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.operation.handler;

import c8y.Command;
import c8y.ua.command.ApplyAllMappingsOperation;
import com.cumulocity.opcua.client.exception.OpcuaClientException;
import com.cumulocity.opcua.client.gateway.GatewayManager;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.exception.ServerNotConnectedException;
import com.cumulocity.opcua.client.gateway.mappings.ServerMappingsRepository;
import com.cumulocity.opcua.client.gateway.operation.exception.OperationExecutionException;
import com.cumulocity.opcua.client.gateway.operation.handler.base.HandleInternalResult;
import com.cumulocity.opcua.client.gateway.operation.handler.base.UAServerOperationHandler;
import com.cumulocity.opcua.client.gateway.subscription.SubscriptionUpdateScheduler;
import com.cumulocity.sdk.client.devicecontrol.DeviceControlApi;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplyAllMappingsOperationHandler
extends UAServerOperationHandler<ApplyAllMappingsOperation> {
    private static final Logger log = LoggerFactory.getLogger(ApplyAllMappingsOperationHandler.class);
    private final ServerMappingsRepository serverMappingsRepository;
    private final SubscriptionUpdateScheduler subscriptionUpdateScheduler;

    @Autowired
    public ApplyAllMappingsOperationHandler(GatewayManager gatewayManager, ConnectionManager connectionManager, DeviceControlApi deviceControlApi, ServerMappingsRepository serverMappingsRepository, SubscriptionUpdateScheduler subscriptionUpdateScheduler) {
        super(gatewayManager, connectionManager, ApplyAllMappingsOperation.class, deviceControlApi);
        this.serverMappingsRepository = serverMappingsRepository;
        this.subscriptionUpdateScheduler = subscriptionUpdateScheduler;
    }

    protected HandleInternalResult handleInternal(ApplyAllMappingsOperation operation) throws OperationExecutionException {
        try {
            this.serverMappingsRepository.scheduleUpdateServerMappings();
            this.subscriptionUpdateScheduler.update();
            Command cmd = new Command();
            cmd.setResult("OK");
            return new HandleInternalResult(cmd, true, null);
        }
        catch (OpcuaClientException | ServerNotConnectedException | InterruptedException | ExecutionException e) {
            log.warn("Could not finish mappings application. Original exception was {}", (Object)e.getMessage(), (Object)e);
            HandleInternalResult errorResult = this.failWithReason("Could not complete mappings application: " + e.getMessage());
            return errorResult;
        }
    }
}

