/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappingsexecution.tasks;

import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.BatchValueEvent;
import com.cumulocity.opcua.common.model.mapping.action.MappingAction;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseBatchTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(BaseBatchTask.class);
    private GId deviceId;
    private String type;
    private BatchValueEvent event;
    Map<String, Collection<MappingAction>> batchActions;

    BaseBatchTask() {
    }

    protected boolean isNullValueReceived(DataValue dataValue) {
        return Objects.isNull(dataValue.getValue()) || Objects.isNull(dataValue.getValue().getValue());
    }

    public GId getDeviceId() {
        return this.deviceId;
    }

    public String getType() {
        return this.type;
    }

    public BatchValueEvent getEvent() {
        return this.event;
    }

    public Map<String, Collection<MappingAction>> getBatchActions() {
        return this.batchActions;
    }

    public void setDeviceId(GId deviceId) {
        this.deviceId = deviceId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setEvent(BatchValueEvent event) {
        this.event = event;
    }

    public void setBatchActions(Map<String, Collection<MappingAction>> batchActions) {
        this.batchActions = batchActions;
    }
}

