/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.jmx;

import com.cumulocity.opcua.client.gateway.jmx.ThreadCountInfo;
import com.cumulocity.opcua.client.gateway.jmx.ThreadCountProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Component;

@Component
public class ThreadCountProviderImpl
implements ThreadCountProvider {
    @Autowired
    private ApplicationContext ctx;

    public Map<String, ThreadCountInfo> getThreadCount() {
        HashMap<String, ThreadCountInfo> threadCount = new HashMap<String, ThreadCountInfo>(this.getSchedulerThreadCount());
        threadCount.putAll(this.getExecutorThreadCount());
        return threadCount;
    }

    private Map<String, ThreadCountInfo> getSchedulerThreadCount() {
        Map executors = this.ctx.getBeansOfType(ThreadPoolTaskScheduler.class);
        return executors.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new ThreadCountInfo(((ThreadPoolTaskScheduler)entry.getValue()).getActiveCount(), ((ThreadPoolTaskScheduler)entry.getValue()).getPoolSize(), ((ThreadPoolTaskScheduler)entry.getValue()).getPoolSize(), ((ThreadPoolTaskScheduler)entry.getValue()).getPoolSize())));
    }

    private Map<String, ThreadCountInfo> getExecutorThreadCount() {
        Map executors = this.ctx.getBeansOfType(ThreadPoolTaskExecutor.class);
        return executors.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new ThreadCountInfo(((ThreadPoolTaskExecutor)entry.getValue()).getActiveCount(), ((ThreadPoolTaskExecutor)entry.getValue()).getCorePoolSize(), ((ThreadPoolTaskExecutor)entry.getValue()).getPoolSize(), ((ThreadPoolTaskExecutor)entry.getValue()).getMaxPoolSize())));
    }
}

