/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.datastore.rocksdb;

import c8y.ua.data.DeviceTypeMappedNodeCollection;
import com.cumulocity.opcua.client.gateway.bootstrap.model.DeviceCredentials;
import com.cumulocity.opcua.client.gateway.datastore.GatewayLocalDatabase;
import com.cumulocity.opcua.client.gateway.datastore.model.EncryptionData;
import com.cumulocity.opcua.client.gateway.datastore.rocksdb.RocksDBSerializer;
import jakarta.annotation.PreDestroy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBGatewayLocalDatabase
implements GatewayLocalDatabase {
    private static final Logger log = LoggerFactory.getLogger(RocksDBGatewayLocalDatabase.class);
    private static final String ENCRYPTION_KEY = "encryption";
    private static final String SCANNED_SERVERS_KEY = "scanned_servers";
    private static final String CRASH_FLAG_KEY = "crash_flag";
    private static final String CREDENTIALS_KEY = "credentials";
    private static final String ALARM_CACHE_PREFIX = "alarm:";
    private static final String DEVICE_TYPE_MAPPING_PREFIX = "device_type:";
    private final RocksDB db;
    private final RocksDBSerializer serializer;
    private final ReadWriteLock scannedServersLock = new ReentrantReadWriteLock();
    private final ReadWriteLock alarmCacheLock = new ReentrantReadWriteLock();
    private final ReadWriteLock deviceTypeMappingLock = new ReentrantReadWriteLock();

    public RocksDBGatewayLocalDatabase(String dbPath, RocksDBSerializer serializer) {
        this.serializer = serializer;
        try {
            RocksDB.loadLibrary();
            Options options = new Options().setCreateIfMissing(true).setCreateMissingColumnFamilies(true);
            Path path = Paths.get(dbPath, new String[0]);
            path.toFile().mkdirs();
            this.db = RocksDB.open((Options)options, (String)dbPath);
            log.info("RocksDB initialized at: {}", (Object)dbPath);
        }
        catch (RocksDBException e) {
            log.error("Failed to initialize RocksDB", (Throwable)e);
            throw new RuntimeException("Could not initialize RocksDB", e);
        }
    }

    public EncryptionData getEncryptionData() {
        try {
            byte[] bytes = this.db.get(ENCRYPTION_KEY.getBytes());
            return bytes != null ? (EncryptionData)this.serializer.deserialize(bytes, EncryptionData.class) : new EncryptionData();
        }
        catch (RocksDBException e) {
            log.error("Failed to get encryption data", (Throwable)e);
            return new EncryptionData();
        }
    }

    public void setEncryptionData(EncryptionData encryptionData) {
        try {
            if (encryptionData == null) {
                this.db.delete(ENCRYPTION_KEY.getBytes());
            } else {
                this.db.put(ENCRYPTION_KEY.getBytes(), this.serializer.serialize((Object)encryptionData));
            }
        }
        catch (RocksDBException e) {
            log.error("Failed to set encryption data", (Throwable)e);
            throw new RuntimeException("Could not set encryption data", e);
        }
    }

    public Set<String> getScannedServers() {
        this.scannedServersLock.readLock().lock();
        try {
            byte[] bytes = this.db.get(SCANNED_SERVERS_KEY.getBytes());
            if (bytes == null) {
                HashSet<String> hashSet = new HashSet<String>();
                return hashSet;
            }
            Set set = (Set)this.serializer.deserialize(bytes, HashSet.class);
            return set;
        }
        catch (RocksDBException e) {
            log.error("Failed to get scanned servers", (Throwable)e);
            HashSet<String> hashSet = new HashSet<String>();
            return hashSet;
        }
        finally {
            this.scannedServersLock.readLock().unlock();
        }
    }

    public void addScannedServer(String serverId) {
        this.scannedServersLock.writeLock().lock();
        try {
            Set servers = this.getScannedServersInternal();
            servers.add(serverId);
            this.db.put(SCANNED_SERVERS_KEY.getBytes(), this.serializer.serialize((Object)servers));
        }
        catch (RocksDBException e) {
            log.error("Failed to add scanned server", (Throwable)e);
            throw new RuntimeException("Could not add scanned server", e);
        }
        finally {
            this.scannedServersLock.writeLock().unlock();
        }
    }

    private Set<String> getScannedServersInternal() throws RocksDBException {
        byte[] bytes = this.db.get(SCANNED_SERVERS_KEY.getBytes());
        if (bytes == null) {
            return new HashSet<String>();
        }
        return (Set)this.serializer.deserialize(bytes, HashSet.class);
    }

    public void removeScannedServer(String serverId) {
        this.scannedServersLock.writeLock().lock();
        try {
            Set servers = this.getScannedServersInternal();
            servers.remove(serverId);
            this.db.put(SCANNED_SERVERS_KEY.getBytes(), this.serializer.serialize((Object)servers));
        }
        catch (RocksDBException e) {
            log.error("Failed to remove scanned server", (Throwable)e);
            throw new RuntimeException("Could not remove scanned server", e);
        }
        finally {
            this.scannedServersLock.writeLock().unlock();
        }
    }

    public String getCrashFlag() {
        try {
            byte[] bytes = this.db.get(CRASH_FLAG_KEY.getBytes());
            return bytes != null ? new String(bytes) : null;
        }
        catch (RocksDBException e) {
            log.error("Failed to get crash flag", (Throwable)e);
            return null;
        }
    }

    public void setCrashFlag(String crashFlag) {
        try {
            if (crashFlag == null) {
                this.db.delete(CRASH_FLAG_KEY.getBytes());
            } else {
                this.db.put(CRASH_FLAG_KEY.getBytes(), crashFlag.getBytes());
            }
        }
        catch (RocksDBException e) {
            log.error("Failed to set crash flag", (Throwable)e);
            throw new RuntimeException("Could not set crash flag", e);
        }
    }

    public DeviceCredentials getCredentials() {
        try {
            byte[] bytes = this.db.get(CREDENTIALS_KEY.getBytes());
            return bytes != null ? (DeviceCredentials)this.serializer.deserialize(bytes, DeviceCredentials.class) : null;
        }
        catch (RocksDBException e) {
            log.error("Failed to get credentials", (Throwable)e);
            return null;
        }
    }

    public void setCredentials(DeviceCredentials credentials) {
        try {
            if (credentials == null) {
                this.db.delete(CREDENTIALS_KEY.getBytes());
            } else {
                this.db.put(CREDENTIALS_KEY.getBytes(), this.serializer.serialize((Object)credentials));
            }
        }
        catch (RocksDBException e) {
            log.error("Failed to set credentials", (Throwable)e);
            throw new RuntimeException("Could not set credentials", e);
        }
    }

    public void addAlarmCache(String alarmKey, String alarmId) {
        try {
            String key = ALARM_CACHE_PREFIX + alarmKey;
            this.db.put(key.getBytes(), alarmId.getBytes());
        }
        catch (RocksDBException e) {
            log.error("Failed to add alarm cache", (Throwable)e);
            throw new RuntimeException("Could not add alarm cache", e);
        }
    }

    public Optional<String> getAlarmCache(String alarmKey) {
        try {
            String key = ALARM_CACHE_PREFIX + alarmKey;
            byte[] bytes = this.db.get(key.getBytes());
            return bytes != null ? Optional.of(new String(bytes)) : Optional.empty();
        }
        catch (RocksDBException e) {
            log.error("Failed to get alarm cache", (Throwable)e);
            return Optional.empty();
        }
    }

    public void removeAlarmCache(String alarmKey) {
        try {
            String key = ALARM_CACHE_PREFIX + alarmKey;
            this.db.delete(key.getBytes());
        }
        catch (RocksDBException e) {
            log.error("Failed to remove alarm cache", (Throwable)e);
            throw new RuntimeException("Could not remove alarm cache", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAlarmCacheSize() {
        this.alarmCacheLock.readLock().lock();
        try {
            int count = 0;
            try (RocksIterator iterator = this.db.newIterator();){
                String key;
                iterator.seek(ALARM_CACHE_PREFIX.getBytes());
                while (iterator.isValid() && (key = new String(iterator.key())).startsWith(ALARM_CACHE_PREFIX)) {
                    ++count;
                    iterator.next();
                }
            }
            int n = count;
            return n;
        }
        finally {
            this.alarmCacheLock.readLock().unlock();
        }
    }

    public void addDeviceTypeMapping(String serverId, DeviceTypeMappedNodeCollection mapping) {
        try {
            String key = DEVICE_TYPE_MAPPING_PREFIX + serverId;
            this.db.put(key.getBytes(), this.serializer.serialize((Object)mapping));
        }
        catch (RocksDBException e) {
            log.error("Failed to add device type mapping", (Throwable)e);
            throw new RuntimeException("Could not add device type mapping", e);
        }
    }

    public Optional<DeviceTypeMappedNodeCollection> getDeviceTypeMapping(String serverId) {
        try {
            String key = DEVICE_TYPE_MAPPING_PREFIX + serverId;
            byte[] bytes = this.db.get(key.getBytes());
            return bytes != null ? Optional.of((DeviceTypeMappedNodeCollection)this.serializer.deserialize(bytes, DeviceTypeMappedNodeCollection.class)) : Optional.empty();
        }
        catch (RocksDBException e) {
            log.error("Failed to get device type mapping", (Throwable)e);
            return Optional.empty();
        }
    }

    public void removeDeviceTypeMapping(String serverId) {
        try {
            String key = DEVICE_TYPE_MAPPING_PREFIX + serverId;
            this.db.delete(key.getBytes());
        }
        catch (RocksDBException e) {
            log.error("Failed to remove device type mapping", (Throwable)e);
            throw new RuntimeException("Could not remove device type mapping", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDeviceTypeMappingSize() {
        this.deviceTypeMappingLock.readLock().lock();
        try {
            int count = 0;
            try (RocksIterator iterator = this.db.newIterator();){
                String key;
                iterator.seek(DEVICE_TYPE_MAPPING_PREFIX.getBytes());
                while (iterator.isValid() && (key = new String(iterator.key())).startsWith(DEVICE_TYPE_MAPPING_PREFIX)) {
                    ++count;
                    iterator.next();
                }
            }
            int n = count;
            return n;
        }
        finally {
            this.deviceTypeMappingLock.readLock().unlock();
        }
    }

    @PreDestroy
    public void close() {
        if (this.db != null) {
            this.setCrashFlag(null);
            this.db.close();
            log.info("RocksDB closed");
        }
    }
}

