/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.configuration;

import com.cumulocity.opcua.client.gateway.datastore.AddressSpaceFileDataStore;
import com.cumulocity.opcua.client.gateway.datastore.DataStore;
import com.cumulocity.opcua.client.gateway.datastore.GatewayLocalDatabase;
import com.cumulocity.opcua.client.gateway.datastore.rocksdb.RocksDBGatewayLocalDatabase;
import com.cumulocity.opcua.client.gateway.datastore.rocksdb.RocksDBSerializer;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DatabaseConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DatabaseConfiguration.class);
    public static final String SERVER_ADDRESS_SPACE_FILE_NAME_W_PROSYS_V3 = "cumulocity-opcua-server-%s-address-space.bin";
    public static final String SERVER_ADDRESS_SPACE_FILE_NAME_W_PROSYS_V4 = "cumulocity-opcua-server-%s-address-space-pv4.bin";
    @Value(value="${gateway.db.baseDir:${user.home}/.opcua/data}")
    private String databasePath;
    @Value(value="${gateway.db.addressSpace.legacyCleanup:true}")
    private boolean cleanupLegacyAddressSpaceLocalDb;

    private void createBaseDirIfNotExist() {
        File baseDir = new File(this.databasePath);
        if (!baseDir.exists()) {
            baseDir.mkdirs();
        }
    }

    @Bean(name={"addressSpaceFileDataStore"})
    public DataStore addressSpaceFileDataStore() {
        this.createBaseDirIfNotExist();
        return new AddressSpaceFileDataStore(this.databasePath, this.cleanupLegacyAddressSpaceLocalDb);
    }

    @Bean
    public RocksDBSerializer rocksDBSerializer() {
        return new RocksDBSerializer();
    }

    @Bean
    public GatewayLocalDatabase gatewayLocalDatabase() {
        this.createBaseDirIfNotExist();
        return new RocksDBGatewayLocalDatabase(this.databasePath + "/rocks-db", this.rocksDBSerializer());
    }

    public String getDatabasePath() {
        return this.databasePath;
    }
}

