/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.subscription;

import com.cumulocity.opcua.client.exception.OpcuaClientException;
import com.cumulocity.opcua.client.gateway.GatewayManager;
import com.cumulocity.opcua.client.gateway.ServerIdentifier;
import com.cumulocity.opcua.client.gateway.connection.model.NamespaceTableChangedEvent;
import com.cumulocity.opcua.client.gateway.connection.model.ServerConnectedEvent;
import com.cumulocity.opcua.client.gateway.connection.model.ServerReconnectedEvent;
import com.cumulocity.opcua.client.gateway.exception.ServerNotConnectedException;
import com.cumulocity.opcua.client.gateway.mappings.model.EventMappingParameters;
import com.cumulocity.opcua.client.gateway.platform.configuration.PlatformProvider;
import com.cumulocity.opcua.client.gateway.subscription.DeviceTypeFetcherService;
import com.cumulocity.opcua.client.gateway.subscription.UaSubscriptionService;
import com.cumulocity.opcua.client.gateway.subscription.UpdateServerSubscriptionTask;
import com.cumulocity.opcua.client.gateway.subscription.model.BaseSubscriptionData;
import com.cumulocity.opcua.client.gateway.subscription.model.DeviceTypeFetchedItems;
import com.cumulocity.opcua.client.gateway.subscription.model.NodeEventTypeId;
import com.cumulocity.opcua.client.gateway.subscription.model.SubscriptionEventData;
import com.prosysopc.ua.stack.core.Identifiers;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SubscriptionUpdateScheduler {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionUpdateScheduler.class);
    @Autowired
    private GatewayManager gatewayManager;
    @Autowired
    private ApplicationContext appContext;
    @Autowired
    private PlatformProvider platformProvider;
    @Autowired
    private UaSubscriptionService uaSubscriptionService;
    @Autowired
    private DeviceTypeFetcherService deviceTypeFetcherService;
    @Value(value="${gateway.modelChanges.eventTypeIdToSubscribe:i=2132}")
    private String modelChangesTypeIdToSubscribe;

    @EventListener(value={ServerConnectedEvent.class})
    @Order(value=1)
    public void onServerConnected(ServerConnectedEvent event) {
        log.info("Server {} connected event, schedule update", (Object)event.getServerIdentifier());
        this.scheduleUpdateAsync(event.getServerIdentifier(), true, false);
        if (Objects.nonNull(event.getClientConfig()) && event.getClientConfig().isSubscribeModelChangeEventEnabled()) {
            this.subscribeBaseModelChangeEvents(event.getServerIdentifier());
        }
    }

    @EventListener(value={NamespaceTableChangedEvent.class})
    public void onNamespaceTableChanged(NamespaceTableChangedEvent event) {
        log.info("Namespace table changed, updating subscription for server: {}", (Object)event.getServerId());
        this.scheduleUpdateAsync(event.getServerId(), true, true);
    }

    @Scheduled(fixedDelayString="${gateway.subscriptionUpdate.interval:60000}", initialDelay=30000L)
    public synchronized void update() throws ExecutionException, InterruptedException {
        log.info("Update subscriptions for knowing servers");
        this.doUpdate(null, false, false);
    }

    @EventListener(value={ServerReconnectedEvent.class})
    public void onServerReconnected(ServerReconnectedEvent reconnectedEvent) {
        log.info("Server reconnected, forcing reapplication of device types for " + String.valueOf(reconnectedEvent.getServerIdentifier()));
        this.scheduleUpdateAsync(reconnectedEvent.getServerIdentifier(), true, true);
        if (Objects.nonNull(reconnectedEvent.getClientConfig()) && reconnectedEvent.getClientConfig().isSubscribeModelChangeEventEnabled()) {
            this.subscribeBaseModelChangeEvents(reconnectedEvent.getServerIdentifier());
        }
    }

    private void subscribeBaseModelChangeEvents(ServerIdentifier serverIdentifier) {
        String serverId = serverIdentifier.getInventoryIdentifier().getValue();
        HashMap<NodeEventTypeId, EventMappingParameters> baseModelChangeEventSubs = new HashMap<NodeEventTypeId, EventMappingParameters>();
        NodeEventTypeId nodeEventTypeId = new NodeEventTypeId(Identifiers.Server.toString(), this.modelChangesTypeIdToSubscribe);
        EventMappingParameters eventMappingParameters = new EventMappingParameters(null, Arrays.asList("EventType", "Changes", "Time"));
        baseModelChangeEventSubs.put(nodeEventTypeId, eventMappingParameters);
        SubscriptionEventData subscriptionEventData = SubscriptionEventData.builder().serverId(serverId).eventSubscriptions(baseModelChangeEventSubs).build();
        try {
            this.uaSubscriptionService.applySubscriptions(serverId, (BaseSubscriptionData)subscriptionEventData);
        }
        catch (OpcuaClientException | ServerNotConnectedException e) {
            log.error("Failed to subscribe base model change events for server {}", (Object)serverIdentifier, (Object)e);
        }
    }

    private void scheduleUpdateAsync(ServerIdentifier serverIdentifier, boolean withAllDeviceTypes, boolean forceReapply) {
        Executors.newFixedThreadPool(1).execute(() -> {
            try {
                this.doUpdate(serverIdentifier, withAllDeviceTypes, forceReapply);
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("Unable to trigger update subscription for server: {}, Reason: {}", (Object)serverIdentifier, (Object)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doUpdate(ServerIdentifier serverIdentifier, boolean withAllDeviceTypes, boolean forceReapply) throws ExecutionException, InterruptedException {
        if (!this.platformProvider.isCredentialsAvailable()) {
            log.info("Platform credentials are not available yet, skip updating subscription and will check again in the next round");
            return;
        }
        Collection<Object> servers = Objects.isNull(serverIdentifier) ? this.gatewayManager.getGatewayDetails().getServerIdentifiers() : Collections.singleton(serverIdentifier);
        if (CollectionUtils.isEmpty(servers)) {
            log.info("No server connected yet!");
            return;
        }
        DeviceTypeFetchedItems deviceTypeFetchedItems = this.deviceTypeFetcherService.getDeviceTypesToApply(withAllDeviceTypes);
        servers = new HashSet<ServerIdentifier>(servers);
        ExecutorService executor = Executors.newFixedThreadPool(servers.size());
        try {
            HashSet futures = new HashSet(servers.size());
            for (ServerIdentifier serverIdentifier2 : servers) {
                String serverId = serverIdentifier2.getInventoryIdentifier().getValue();
                UpdateServerSubscriptionTask updateTask = (UpdateServerSubscriptionTask)this.appContext.getBean(UpdateServerSubscriptionTask.class);
                updateTask.setServerId(serverId);
                updateTask.setDeviceTypeFetchedItems(deviceTypeFetchedItems);
                updateTask.setForceReapply(forceReapply);
                futures.add(executor.submit((Runnable)updateTask));
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    log.error("Execution of updateTask failed by callable returns {} with error", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        finally {
            executor.shutdown();
        }
    }
}

