/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.platform.repository.strategy;

import com.cumulocity.opcua.client.gateway.platform.repository.BaseQueuedRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.interceptor.ProcessingModeContext;
import com.cumulocity.opcua.client.gateway.platform.repository.strategy.DefaultFlushExecutor;
import com.cumulocity.opcua.client.gateway.platform.repository.strategy.ProcessingFlushExecutor;
import com.cumulocity.opcua.client.gateway.platform.repository.util.ElementQueueOperation;
import com.cumulocity.rest.representation.AbstractExtensibleRepresentation;
import com.cumulocity.sdk.client.ProcessingMode;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class FlushExecutor<T extends AbstractExtensibleRepresentation, Z> {
    private static final Logger log = LoggerFactory.getLogger(FlushExecutor.class);
    protected ElementQueueOperation<T, Z> elementQueueOperation;
    protected BaseQueuedRepository<T, Z> baseQueuedRepository;
    private final ProcessingFlushExecutor<T, Z> processingFlushExecutor;
    private final DefaultFlushExecutor<T, Z> defaultFlushExecutor;

    public FlushExecutor(ElementQueueOperation<T, Z> elementQueueOperation, BaseQueuedRepository<T, Z> baseQueuedRepository) {
        this.elementQueueOperation = elementQueueOperation;
        this.baseQueuedRepository = baseQueuedRepository;
        this.processingFlushExecutor = new ProcessingFlushExecutor(baseQueuedRepository, elementQueueOperation);
        this.defaultFlushExecutor = new DefaultFlushExecutor(baseQueuedRepository, elementQueueOperation);
    }

    public void flush(ConcurrentLinkedQueue<T> queue) {
        int elementsLeft;
        this.baseQueuedRepository.reportExecutor();
        String pmName = this.baseQueuedRepository.getModeName();
        if (!queue.isEmpty()) {
            log.debug("{}: Scheduling elements with processing mode: {}, queue size: {}", new Object[]{this.baseQueuedRepository.getName(), pmName, queue.size()});
            while (!queue.isEmpty()) {
                Object element = this.elementQueueOperation.getFromQueue(queue);
                if (ProcessingModeContext.isInPMContext()) {
                    this.processingFlushExecutor.executeFlush(element, (ProcessingMode)ProcessingModeContext.PMContext.getPM().get());
                    continue;
                }
                this.defaultFlushExecutor.executeFlush(element);
            }
            log.debug("{}: Scheduling elements with processing mode {} done. Current executor stats: ", (Object)this.baseQueuedRepository.getName(), (Object)pmName);
            this.dumpCurrentExecutorState();
        }
        if ((elementsLeft = this.baseQueuedRepository.getExecutor().getThreadPoolExecutor().getQueue().size()) > 0) {
            log.info("{}: Elements left to flush with processing mode {}: {}", new Object[]{this.baseQueuedRepository.getName(), pmName, elementsLeft});
        }
    }

    private void dumpCurrentExecutorState() {
        if (log.isDebugEnabled()) {
            String repositoryName = this.baseQueuedRepository.getName();
            ThreadPoolTaskExecutor executor = this.baseQueuedRepository.getExecutor();
            log.debug("{} executor pool size: {}", (Object)repositoryName, (Object)executor.getPoolSize());
            log.debug("{} executor active count: {}", (Object)repositoryName, (Object)executor.getActiveCount());
            log.debug("{} executor queue size: {}", (Object)repositoryName, (Object)executor.getThreadPoolExecutor().getQueue().size());
        }
    }
}

