/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.platform.repository;

import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.gateway.platform.repository.InventoryPresence;
import com.cumulocity.sdk.client.SDKException;
import com.cumulocity.sdk.client.inventory.InventoryApi;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import net.jodah.expiringmap.ExpiringEntryLoader;
import net.jodah.expiringmap.ExpiringMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InventoryPresence {
    private static final Logger log = LoggerFactory.getLogger(InventoryPresence.class);
    private static final long ENTRY_LIFETIME_MISSING = 3600L;
    private static final long ENTRY_LIFETIME_EXISTING = 5L;
    private ExpiringMap<GId, Boolean> inventoryPresenceCache = ExpiringMap.builder().expiringEntryLoader((ExpiringEntryLoader)new ExpiringInventoryPresenceLoader(this)).build();
    private Cache<GId, String> inventoryMissingCache = CacheBuilder.newBuilder().expireAfterWrite(3600L, TimeUnit.SECONDS).build();
    @Autowired
    private InventoryApi inventoryApi;

    public boolean isKnownMissingSource(GId source) {
        String value = (String)this.inventoryMissingCache.getIfPresent((Object)source);
        return StringUtils.isNotEmpty((CharSequence)value);
    }

    public boolean checkSourceAvailability(GId source) {
        return (Boolean)this.inventoryPresenceCache.get((Object)source);
    }

    private boolean canAccessInventory(GId source) throws Exception {
        try {
            this.inventoryApi.get(source);
            log.debug("Validated inventory availability for mo {} (exists)", (Object)source);
            return true;
        }
        catch (SDKException e) {
            if (e.getHttpStatus() == 404) {
                log.debug("Cannot find {} in Inventory", (Object)source);
                return false;
            }
            throw e;
        }
    }
}

