/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.platform.repository;

import com.cumulocity.model.ID;
import com.cumulocity.model.idtype.GId;
import com.cumulocity.rest.representation.identity.ExternalIDRepresentation;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.cumulocity.sdk.client.SDKException;
import com.cumulocity.sdk.client.identity.IdentityApi;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class IdentityRepository {
    private static final Logger log = LoggerFactory.getLogger(IdentityRepository.class);
    private final IdentityApi identityApi;

    public Optional<ExternalIDRepresentation> get(ID id) {
        try {
            ExternalIDRepresentation existingExternalId = this.identityApi.getExternalId(id);
            return Optional.ofNullable(existingExternalId);
        }
        catch (SDKException ex) {
            if (ex.getHttpStatus() == 404) {
                return Optional.empty();
            }
            throw ex;
        }
    }

    public ExternalIDRepresentation create(ID identity, GId managedObjectId, int retries) {
        if (retries < 1) {
            return this.create(identity, managedObjectId);
        }
        try {
            return this.create(identity, managedObjectId);
        }
        catch (Exception e) {
            log.warn("Error creating identity: {}, retrying..", (Object)e.getMessage());
            return this.create(identity, managedObjectId, --retries);
        }
    }

    public ExternalIDRepresentation create(ID id, GId managedObjectId) {
        ExternalIDRepresentation externalId = new ExternalIDRepresentation();
        externalId.setExternalId(id.getValue());
        externalId.setType(id.getType());
        ManagedObjectRepresentation managedObjectRepresentation = new ManagedObjectRepresentation();
        managedObjectRepresentation.setId(managedObjectId);
        externalId.setManagedObject(managedObjectRepresentation);
        return this.identityApi.create(externalId);
    }

    @Autowired
    public IdentityRepository(IdentityApi identityApi) {
        this.identityApi = identityApi;
    }
}

