/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.platform.repository;

import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.gateway.platform.repository.BaseQueuedRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.InventoryPresence;
import com.cumulocity.opcua.client.gateway.platform.repository.QueuedRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.interceptor.ProcessingModeContext;
import com.cumulocity.opcua.client.gateway.platform.repository.strategy.FlushExecutor;
import com.cumulocity.opcua.client.gateway.platform.repository.util.SingleElementQueueOperation;
import com.cumulocity.rest.representation.AbstractExtensibleRepresentation;
import com.cumulocity.sdk.client.ProcessingMode;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public abstract class BaseQueuedRepository<T extends AbstractExtensibleRepresentation, Z>
implements QueuedRepository<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseQueuedRepository.class);
    ConcurrentLinkedQueue<T> queue = new ConcurrentLinkedQueue();
    ConcurrentLinkedQueue<T> queueForTransientPMode = new ConcurrentLinkedQueue();
    ConcurrentLinkedQueue<T> queueForQuiescentPMode = new ConcurrentLinkedQueue();
    ConcurrentLinkedQueue<T> queueForCepPMode = new ConcurrentLinkedQueue();
    private final SingleElementQueueOperation<T> singleElementQueueOperation = new SingleElementQueueOperation(this);
    private static final String DEFAULT_MODE_NAME = "DEFAULT";
    @Autowired
    InventoryPresence inventoryPresence;
    @Autowired
    ProcessingModeContext processingModeContext;

    public int getQueueSize() {
        return this.queue.size() + this.queueForTransientPMode.size() + this.queueForQuiescentPMode.size() + this.queueForCepPMode.size();
    }

    public void addToQueue(T element) {
        this.addToQueue(this.queue, DEFAULT_MODE_NAME, element);
    }

    public void addToQueue(T element, ProcessingMode processingMode) {
        ConcurrentLinkedQueue queue = this.getQueue(processingMode);
        this.addToQueue(queue, processingMode.name(), element);
    }

    private void addToQueue(ConcurrentLinkedQueue<T> queue, String modeName, T element) {
        log.trace("{}: Adding element {} to queue with processing mode {}:", new Object[]{this.getName(), element, modeName});
        this.singleElementQueueOperation.addToQueueWithSourceCheck(queue, element);
        log.trace("{}: Queue size with processing mode {}: {}", new Object[]{this.getName(), modeName, queue.size()});
    }

    @Scheduled(fixedDelayString="${gateway.repositories.flushInterval}")
    public void flush() {
        if (!this.queueForTransientPMode.isEmpty()) {
            this.flush(this.queueForTransientPMode, ProcessingMode.TRANSIENT);
        }
        if (!this.queueForQuiescentPMode.isEmpty()) {
            this.flush(this.queueForQuiescentPMode, ProcessingMode.QUIESCENT);
        }
        if (!this.queueForCepPMode.isEmpty()) {
            this.flush(this.queueForCepPMode, ProcessingMode.CEP);
        }
        if (!this.queue.isEmpty()) {
            this.flush(this.queue);
        }
    }

    private void flush(ConcurrentLinkedQueue<T> queue) {
        try {
            this.getFlushStrategy().flush(queue);
        }
        catch (Exception e) {
            log.error("{}: Cannot flush default queue", (Object)this.getName(), (Object)e);
        }
    }

    private void flush(ConcurrentLinkedQueue<T> queue, ProcessingMode processingMode) {
        try {
            this.processingModeContext.executeInPMContext(processingMode, () -> this.getFlushStrategy().flush(queue));
        }
        catch (Exception e) {
            log.error("{}: Cannot flush queue for processing mode {}", new Object[]{processingMode.name(), this.getName(), e});
        }
    }

    public String getModeName() {
        if (ProcessingModeContext.isInPMContext()) {
            return ((ProcessingMode)ProcessingModeContext.PMContext.getPM().get()).name();
        }
        return DEFAULT_MODE_NAME;
    }

    public ConcurrentLinkedQueue<T> getQueue() {
        if (ProcessingModeContext.isInPMContext()) {
            return this.getQueue((ProcessingMode)ProcessingModeContext.PMContext.getPM().get());
        }
        return this.queue;
    }

    private ConcurrentLinkedQueue<T> getQueue(ProcessingMode processingMode) {
        switch (1.$SwitchMap$com$cumulocity$sdk$client$ProcessingMode[processingMode.ordinal()]) {
            case 1: {
                return this.queue;
            }
            case 2: {
                return this.queueForTransientPMode;
            }
            case 3: {
                return this.queueForQuiescentPMode;
            }
            case 4: {
                return this.queueForCepPMode;
            }
        }
        log.error("Unexpected processing mode: {}. Returning PERSISTENT queue", (Object)processingMode.name());
        return this.queue;
    }

    public int getItemsWaitingToFlush() {
        return this.getExecutor().getThreadPoolExecutor().getQueue().size();
    }

    public abstract void createElement(Z var1);

    public abstract GId getElementSource(T var1);

    public abstract ThreadPoolTaskExecutor getExecutor();

    public abstract void reportExecutor();

    protected abstract FlushExecutor<T, Z> getFlushStrategy();

    public ConcurrentLinkedQueue<T> getQueueForTransientPMode() {
        return this.queueForTransientPMode;
    }

    public ConcurrentLinkedQueue<T> getQueueForQuiescentPMode() {
        return this.queueForQuiescentPMode;
    }

    public ConcurrentLinkedQueue<T> getQueueForCepPMode() {
        return this.queueForCepPMode;
    }

    public void setInventoryPresence(InventoryPresence inventoryPresence) {
        this.inventoryPresence = inventoryPresence;
    }

    public InventoryPresence getInventoryPresence() {
        return this.inventoryPresence;
    }

    public void setProcessingModeContext(ProcessingModeContext processingModeContext) {
        this.processingModeContext = processingModeContext;
    }
}

