/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.platform.configuration;

import com.cumulocity.opcua.client.gateway.platform.configuration.PlatformProvider;
import com.cumulocity.sdk.client.RestOperations;
import com.cumulocity.sdk.client.alarm.AlarmApi;
import com.cumulocity.sdk.client.devicecontrol.DeviceControlApi;
import com.cumulocity.sdk.client.event.EventApi;
import com.cumulocity.sdk.client.identity.IdentityApi;
import com.cumulocity.sdk.client.inventory.BinariesApi;
import com.cumulocity.sdk.client.inventory.InventoryApi;
import com.cumulocity.sdk.client.measurement.MeasurementApi;
import com.cumulocity.sdk.client.option.SystemOptionApi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;

@Configuration
public class PlatformConfiguration {
    @Autowired
    private PlatformProvider platformProvider;

    @Bean
    @Scope(scopeName="prototype", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public IdentityApi identityApi() {
        return this.platformProvider.get().getIdentityApi();
    }

    @Bean
    @Scope(scopeName="prototype", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public InventoryApi inventoryApi() {
        return this.platformProvider.get().getInventoryApi();
    }

    @Bean
    @Scope(scopeName="prototype", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public RestOperations restOperations() {
        return this.platformProvider.get().rest();
    }

    @Bean
    @Primary
    @Scope(scopeName="prototype", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public AlarmApi alarmApi() {
        return this.platformProvider.get().getAlarmApi();
    }

    @Bean
    @Scope(scopeName="prototype", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public BinariesApi binariesApi() {
        return this.platformProvider.get().getBinariesApi();
    }

    @Bean
    @Scope(scopeName="prototype", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public EventApi eventApi() {
        return this.platformProvider.get().getEventApi();
    }

    @Bean
    @Scope(scopeName="prototype", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public DeviceControlApi deviceControlApi() {
        return this.platformProvider.get().getDeviceControlApi();
    }

    @Bean
    @Scope(scopeName="prototype", proxyMode=ScopedProxyMode.TARGET_CLASS)
    @Primary
    public MeasurementApi measurementApi() {
        return this.platformProvider.get().getMeasurementApi();
    }

    @Bean
    @Scope(scopeName="prototype", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public SystemOptionApi systemOptionApi() {
        return this.platformProvider.get().getSystemOptionApi();
    }
}

