/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.operation.handler;

import c8y.Command;
import c8y.ua.command.TestDeviceTypeMatching;
import c8y.ua.data.DeviceTypeMatchingDiagnostic;
import com.cumulocity.opcua.client.exception.OpcuaClientException;
import com.cumulocity.opcua.client.gateway.AddressSpaceScanner;
import com.cumulocity.opcua.client.gateway.GatewayManager;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.exception.ServerNotConnectedException;
import com.cumulocity.opcua.client.gateway.mappings.DeviceTypeMatchingService;
import com.cumulocity.opcua.client.gateway.mappings.DeviceTypeRepository;
import com.cumulocity.opcua.client.gateway.operation.handler.base.HandleInternalResult;
import com.cumulocity.opcua.client.gateway.operation.handler.base.UAServerOperationHandler;
import com.cumulocity.opcua.client.serialization.OpcuaSerializer;
import com.cumulocity.opcua.common.model.mapping.DeviceType;
import com.cumulocity.sdk.client.devicecontrol.DeviceControlApi;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TestDeviceTypeMatchingOperationHandler
extends UAServerOperationHandler<TestDeviceTypeMatching> {
    private static final Logger log = LoggerFactory.getLogger(TestDeviceTypeMatchingOperationHandler.class);
    private final DeviceTypeMatchingService deviceTypeMatchingService;
    private final DeviceTypeRepository deviceTypeRepository;

    @Autowired
    public TestDeviceTypeMatchingOperationHandler(GatewayManager gatewayManager, ConnectionManager connectionManager, DeviceControlApi deviceControlApi, DeviceTypeMatchingService deviceTypeMatchingService, DeviceTypeRepository deviceTypeRepository, AddressSpaceScanner addressSpaceScanner) {
        super(gatewayManager, connectionManager, TestDeviceTypeMatching.class, deviceControlApi);
        this.deviceTypeMatchingService = deviceTypeMatchingService;
        this.deviceTypeRepository = deviceTypeRepository;
    }

    protected HandleInternalResult handleInternal(TestDeviceTypeMatching operation) {
        String serverId = operation.getDeviceId().getValue();
        DeviceType deviceType = this.deviceTypeRepository.getDeviceType(operation.getDeviceTypeId());
        if (Objects.isNull(deviceType)) {
            return this.failWithReason("Device type is not found with ID: " + operation.getDeviceTypeId());
        }
        try {
            DeviceTypeMatchingDiagnostic deviceTypeMatchingDiagnostic = this.deviceTypeMatchingService.testMatching(serverId, deviceType, operation.getRootNodeId());
            log.info("Device type: {} {} node: {}", new Object[]{deviceType.getId(), deviceTypeMatchingDiagnostic.isMatches() ? "matches" : "does not match", operation.getRootNodeId()});
            HandleInternalResult result = new HandleInternalResult();
            result.setSuccessful(true);
            Command commandResult = new Command();
            commandResult.setResult(OpcuaSerializer.getInstance().toJson((Object)deviceTypeMatchingDiagnostic));
            result.setCommand(commandResult);
            return result;
        }
        catch (OpcuaClientException | ServerNotConnectedException e) {
            String message = "Unable to test for device type matching due to OpcuaClientException";
            log.info(message, e);
            return this.failWithReason(message);
        }
    }
}

