/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.operation.handler;

import c8y.Command;
import c8y.ua.command.DryRunDeviceTypeMatching;
import com.cumulocity.opcua.client.exception.OpcuaClientException;
import com.cumulocity.opcua.client.gateway.GatewayManager;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.exception.ServerNotConnectedException;
import com.cumulocity.opcua.client.gateway.mappings.DeviceTypeMatchingService;
import com.cumulocity.opcua.client.gateway.mappings.DeviceTypeRepository;
import com.cumulocity.opcua.client.gateway.operation.exception.OperationExecutionException;
import com.cumulocity.opcua.client.gateway.operation.handler.base.HandleInternalResult;
import com.cumulocity.opcua.client.gateway.operation.handler.base.UAServerOperationHandler;
import com.cumulocity.opcua.common.model.mapping.DeviceType;
import com.cumulocity.sdk.client.SDKException;
import com.cumulocity.sdk.client.devicecontrol.DeviceControlApi;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class DryRunDeviceTypeMatchingOperationHandler
extends UAServerOperationHandler<DryRunDeviceTypeMatching> {
    private static final Logger log = LoggerFactory.getLogger(DryRunDeviceTypeMatchingOperationHandler.class);
    private DeviceTypeMatchingService deviceTypeMatchingService;
    private DeviceTypeRepository deviceTypeRepository;

    @Autowired
    public DryRunDeviceTypeMatchingOperationHandler(GatewayManager gatewayManager, ConnectionManager connectionManager, DeviceControlApi deviceControlApi, DeviceTypeMatchingService deviceTypeMatchingService, DeviceTypeRepository deviceTypeRepository) {
        super(gatewayManager, connectionManager, DryRunDeviceTypeMatching.class, deviceControlApi);
        this.deviceTypeMatchingService = deviceTypeMatchingService;
        this.deviceTypeRepository = deviceTypeRepository;
    }

    protected HandleInternalResult handleInternal(DryRunDeviceTypeMatching dryRun) throws OperationExecutionException {
        String serverId = dryRun.getDeviceId().getValue();
        String deviceTypeId = dryRun.getDeviceTypeId();
        if (Objects.isNull(serverId)) {
            log.error("Retrieved Operation with serverId being null. This should not happen. Operation Details: {}", (Object)dryRun);
            this.failWithReason("ServerId is a mandatory parameter for this operation, but hasn't been provided. This actually should not happen. Error has been logged.");
        }
        if (Objects.isNull(deviceTypeId)) {
            this.failWithReason("deviceTypeId is a mandatory parameter for this operation, but hasn't been provided");
        }
        DeviceType deviceTypeToTest = null;
        try {
            deviceTypeToTest = this.deviceTypeRepository.getDeviceType(deviceTypeId);
        }
        catch (SDKException e) {
            if (e.getHttpStatus() == 404) {
                return this.failWithReason("Device protocol " + deviceTypeId + " not found.");
            }
            log.error("Couldn't get device protocol for unknown reason. Rethrowing exception");
            throw e;
        }
        if (deviceTypeToTest == null) {
            return this.failWithReason("Device protocol " + deviceTypeId + " could not be retrieved.");
        }
        ArrayList deviceTypes = Lists.newArrayList((Object[])new DeviceType[]{deviceTypeToTest});
        try {
            Collection foundNodes = this.deviceTypeMatchingService.matches(serverId, (List)deviceTypes, true);
            HandleInternalResult internalResult = new HandleInternalResult();
            internalResult.setSuccessful(true);
            Command command = new Command();
            Object result = "";
            if (!deviceTypeToTest.isEnabled()) {
                result = (String)result + "Device protocol is currently disabled. ";
            }
            result = (String)result + "Device protocol would be applied to the following nodes: " + DryRunDeviceTypeMatchingOperationHandler.toJSON((Collection)foundNodes);
            command.setResult((String)result);
            command.setProperty("matchedNodes", (Object)foundNodes);
            internalResult.setCommand(command);
            return internalResult;
        }
        catch (ServerNotConnectedException e) {
            log.debug("Testing to match a device protocol resulted in a ServerNotConnectedException. Details: ", (Throwable)e);
            return this.failWithReason("Server not connected. Detailed message: " + e.getMessage());
        }
        catch (OpcuaClientException e) {
            log.debug("OPC UA Client Exception while testing a device protocol: ", (Throwable)e);
            return this.failWithReason("OPC UA Client exception. Detailed message:" + e.getMessage());
        }
    }
}

