/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.operation.handler;

import c8y.Command;
import c8y.ua.command.BaseOperation;
import c8y.ua.command.CallMethodOperation;
import c8y.ua.data.MethodArgument;
import c8y.ua.data.MethodRequest;
import c8y.ua.data.MethodResponse;
import com.cumulocity.opcua.client.NodeIds;
import com.cumulocity.opcua.client.OpcuaClient;
import com.cumulocity.opcua.client.exception.OpcuaClientException;
import com.cumulocity.opcua.client.gateway.GatewayManager;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.operation.exception.OperationExecutionException;
import com.cumulocity.opcua.client.gateway.operation.handler.base.HandleInternalResult;
import com.cumulocity.opcua.client.gateway.operation.handler.base.UAOperationHandler;
import com.cumulocity.opcua.client.gateway.operation.handler.base.UAOperationNodeValidator;
import com.cumulocity.opcua.client.serialization.OpcuaSerializer;
import com.cumulocity.sdk.client.devicecontrol.DeviceControlApi;
import com.cumulocity.sdk.client.inventory.InventoryApi;
import com.prosysopc.ua.stack.common.NamespaceTable;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CallMethodOperationHandler
extends UAOperationHandler<CallMethodOperation> {
    private static final Logger log = LoggerFactory.getLogger(CallMethodOperationHandler.class);

    @Autowired
    public CallMethodOperationHandler(GatewayManager gatewayManager, ConnectionManager connectionManager, DeviceControlApi deviceControlApi, InventoryApi inventoryApi, UAOperationNodeValidator nodeValidator) {
        super(gatewayManager, connectionManager, CallMethodOperation.class, deviceControlApi, inventoryApi, nodeValidator);
    }

    protected HandleInternalResult handleInternal(CallMethodOperation operation) throws OperationExecutionException {
        MethodRequest request = operation.getRequest();
        Optional clientOptional = this.resolveClient((BaseOperation)operation);
        if (!clientOptional.isPresent()) {
            throw new OperationExecutionException("UA Server is not resolvable / not connected!");
        }
        OpcuaClient client = (OpcuaClient)clientOptional.get();
        try {
            MethodResponse response = client.call(request);
            this.useNsUriForMethod(response, client);
            String jsonValue = OpcuaSerializer.getInstance().toJson((Object)response);
            Command cmd = new Command();
            cmd.setResult(jsonValue);
            return new HandleInternalResult(cmd, true, null);
        }
        catch (OpcuaClientException e) {
            throw new OperationExecutionException((Throwable)e);
        }
    }

    private void useNsUriForMethod(MethodResponse method, OpcuaClient client) {
        if (Objects.nonNull(method.getResult())) {
            for (MethodArgument arg : method.getResult()) {
                arg.setDataTypeId(NodeIds.toNodeIdWithNsUri((NamespaceTable)client.getNamespaceTable(), (String)arg.getDataTypeId()));
            }
        }
    }

    protected Set<String> getQueryNodes(CallMethodOperation operation) {
        return operation.getRequest().getNodeId() != null ? Set.of(operation.getRequest().getNodeId()) : Set.of();
    }
}

