/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.notification;

import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.gateway.bootstrap.model.BootstrapReadyEvent;
import com.cumulocity.opcua.client.gateway.connection.model.ServerConnectedEvent;
import com.cumulocity.opcua.client.gateway.connection.model.ServerDisconnectedEvent;
import com.cumulocity.opcua.client.gateway.operation.OperationExecutor;
import com.cumulocity.rest.representation.operation.OperationRepresentation;
import com.cumulocity.sdk.client.devicecontrol.DeviceControlApi;
import com.cumulocity.sdk.client.notification.Subscriber;
import com.cumulocity.sdk.client.notification.Subscription;
import com.cumulocity.sdk.client.notification.SubscriptionListener;
import jakarta.annotation.PreDestroy;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class OperationSubscriber {
    private static final Logger log = LoggerFactory.getLogger(OperationSubscriber.class);
    private final DeviceControlApi deviceControlApi;
    private final OperationExecutor operationExecutor;
    private Map<GId, Subscription<GId>> subscriptions = new ConcurrentHashMap();
    private Subscriber<GId, OperationRepresentation> operationSubscriber;

    public void resubscribe() {
        log.info("Forced closing COMET connection and resubscribing to devices.");
        HashSet gIdsToResubscribe = new HashSet(this.subscriptions.keySet());
        this.close();
        for (GId gid : gIdsToResubscribe) {
            this.subscribeForOperations(gid);
        }
    }

    @EventListener
    @Async
    public void subscribeForOperations(BootstrapReadyEvent bootstrapReadyEvent) {
        log.info("Subscribing device operations for device gateway: {}", (Object)bootstrapReadyEvent.getGatewayDevice().getId());
        this.subscribeForOperations(bootstrapReadyEvent.getGatewayDevice().getId());
    }

    @EventListener
    @Async
    @Order
    public void subscribeForOperations(ServerConnectedEvent serverConnectedEvent) {
        log.info("Subscribing device operations for OPCUA Server: {}", (Object)serverConnectedEvent.getServerIdentifier());
        GId deviceId = serverConnectedEvent.getServerIdentifier().getInventoryIdentifier();
        this.subscribeForOperations(deviceId);
    }

    @EventListener
    @Async
    public void unsubscribe(ServerDisconnectedEvent serverDisconnectedEvent) {
        log.info("Unsubscribing notification for OPCUA server: {}", (Object)serverDisconnectedEvent.getServerIdentifier());
        GId deviceId = serverDisconnectedEvent.getServerIdentifier().getInventoryIdentifier();
        if (this.subscriptions.containsKey(deviceId)) {
            ((Subscription)this.subscriptions.remove(deviceId)).unsubscribe();
        }
    }

    @PreDestroy
    public void close() {
        log.info("Unsubscribing [{}] subscriptions and disconnecting the subscriber...", (Object)this.subscriptions.size());
        this.subscriptions.values().stream().forEach(Subscription::unsubscribe);
        if (!Objects.isNull(this.operationSubscriber)) {
            this.operationSubscriber.disconnect();
        }
        log.info("Subscriber disconnected");
    }

    void subscribeForOperations(GId deviceId) {
        if (Objects.isNull(this.operationSubscriber)) {
            this.operationSubscriber = this.deviceControlApi.getNotificationsSubscriber();
        }
        try {
            Subscription subscription = this.operationSubscriber.subscribe((Object)deviceId, (SubscriptionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.subscriptions.put(deviceId, subscription);
        }
        catch (Exception e) {
            log.warn("Unable to subscribe to comet session!", (Throwable)e);
        }
    }

    @Autowired
    public OperationSubscriber(DeviceControlApi deviceControlApi, OperationExecutor operationExecutor) {
        this.deviceControlApi = deviceControlApi;
        this.operationExecutor = operationExecutor;
    }
}

