/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappingsexecution.tasks;

import com.cumulocity.model.event.CumulocitySeverities;
import com.cumulocity.opcua.client.gateway.mappingsexecution.exception.InvalidDataTypeException;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.BaseBatchTask;
import com.cumulocity.opcua.client.gateway.platform.repository.ThinEdgeAlarmRepository;
import com.cumulocity.opcua.common.model.mapping.action.MappingAction;
import com.cumulocity.opcua.common.model.mapping.action.MeasurementCreation;
import com.cumulocity.opcua.common.validation.ValueLimitsValidator;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ThinEdgeBatchMeasurementCreationTask
extends BaseBatchTask {
    private static final Logger log = LoggerFactory.getLogger(ThinEdgeBatchMeasurementCreationTask.class);
    @Autowired
    private MqttClient mqttClient;
    @Autowired
    private ThinEdgeAlarmRepository alarmRepository;

    public void run() {
        try {
            HashMap measurement = new HashMap();
            for (String nodeId : this.getBatchActions().keySet()) {
                this.addFragmentsForNodeTo(measurement, nodeId, (Collection)this.getBatchActions().get(nodeId), (DataValue)this.getEvent().getValues().get(nodeId));
            }
            String topic = "te/device/" + this.getDeviceId().getValue() + "///m/" + this.getType();
            Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
            MqttMessage message = new MqttMessage();
            message.setPayload(gson.toJson(measurement).getBytes());
            this.mqttClient.publish(topic, message);
        }
        catch (MqttException e) {
            this.alarmRepository.create(this.getDeviceId(), "opcuaMqttPublishFailed", CumulocitySeverities.MAJOR.name(), "Failed to publish MQTT message: " + e.getMessage());
            log.error("Failed to publish MQTT message: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void addFragmentsForNodeTo(Map<String, Object> measurement, String nodeId, Collection<MappingAction> actions, DataValue dataValue) {
        BigDecimal value;
        if (this.isNullValueReceived(dataValue)) {
            return;
        }
        try {
            value = ValueLimitsValidator.readNumericValue((Object)dataValue.getValue().getValue());
        }
        catch (NumberFormatException e) {
            String errorMessage = "Invalid data type in OPC-UA measurement mapping:\n  nodeId: " + nodeId + "\n  serverId: " + this.getEvent().getServerId() + "\n  received type: " + dataValue.getClass().getName() + "\n  received value string: " + dataValue.toString();
            this.alarmRepository.create(this.getDeviceId(), "opcuaInvalidMappingDataType", CumulocitySeverities.MAJOR.name(), errorMessage);
            throw new InvalidDataTypeException("Couldn't parse " + dataValue.toString() + " to BigDecimal");
        }
        if (Objects.isNull(value)) {
            return;
        }
        for (MappingAction action : actions) {
            if (action instanceof MeasurementCreation) {
                MeasurementCreation measurementCreation = (MeasurementCreation)action;
                Map measurementFragment = measurement.containsKey(measurementCreation.getFragmentName()) ? (Map)measurement.get(measurementCreation.getFragmentName()) : new HashMap();
                String measurementSeriesName = measurementCreation.getSeriesName(nodeId);
                measurementFragment.put(measurementSeriesName, value);
                measurement.put(measurementCreation.getFragmentName(), measurementFragment);
                continue;
            }
            log.warn("Unsupported action type for ThinEdge measurement: {}", (Object)action.getClass().getSimpleName());
        }
    }

    public void setMqttClient(MqttClient mqttClient) {
        this.mqttClient = mqttClient;
    }

    public void setAlarmRepository(ThinEdgeAlarmRepository alarmRepository) {
        this.alarmRepository = alarmRepository;
    }
}

