/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappingsexecution.tasks;

import com.cumulocity.opcua.client.gateway.mappingsexecution.HttpPostQueue;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.HttpPostElement;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.BaseTask;
import com.cumulocity.opcua.common.model.mapping.action.HttpPostAction;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class HttpPostElementCreationTask
extends BaseTask {
    private static final Logger log = LoggerFactory.getLogger(HttpPostElementCreationTask.class);
    @Autowired
    private HttpPostQueue queue;
    private HttpPostAction postAction;

    public void run() {
        this.queue.add(HttpPostElement.fromAction((HttpPostAction)this.postAction, (String)this.httpPostBody(), (String)this.getDeviceId().getValue(), (Long)this.queue.nextElementId()));
    }

    private String httpPostBody() {
        return this.postAction.getBodyTemplate().replaceAll("\\$\\{value}", this.getValueAsJsonString()).replaceAll("\\$\\{serverId}", this.getEvent().getServerId()).replaceAll("\\$\\{nodeId}", this.getEvent().getNodeId()).replaceAll("\\$\\{deviceId}", this.getDeviceId().getValue()).replaceAll("\\$\\{receivedTimestampInMs}", String.valueOf(DateTime.now().getMillis()));
    }

    public void setPostAction(HttpPostAction postAction) {
        this.postAction = postAction;
    }
}

