/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappingsexecution;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class HttpRequestExecutor {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestExecutor.class);
    @Autowired
    private HttpClient client;
    private RequestConfig requestConfig;

    public HttpRequestExecutor(@Value(value="${gateway.mappingExecution.http.connectionRequestTimeout}") int connectionRequestTimeout, @Value(value="${gateway.mappingExecution.http.connectionTimeout}") int connectionTimeout, @Value(value="${gateway.mappingExecution.http.socketTimeout}") int socketTimeout) {
        this.requestConfig = RequestConfig.custom().setConnectionRequestTimeout(connectionRequestTimeout).setConnectTimeout(connectionTimeout).setSocketTimeout(socketTimeout).build();
    }

    public HttpResponse httpPostRequest(String endPoint, Map<String, String> headers, HttpEntity httpEntity) throws IOException {
        HttpPost httpPost = new HttpPost();
        httpPost.setConfig(this.requestConfig);
        httpPost.setURI(URI.create(endPoint));
        if (!headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPost.addHeader(entry.getKey(), entry.getValue());
            }
        }
        httpPost.setEntity(httpEntity);
        return this.client.execute((HttpUriRequest)httpPost);
    }
}

