/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappings;

import c8y.ua.Node;
import c8y.ua.data.BrowsePathProperty;
import c8y.ua.data.DeviceTypeMappedNode;
import c8y.ua.data.MappedTargetNode;
import com.cumulocity.opcua.client.NodeIds;
import com.cumulocity.opcua.client.gateway.mappings.RegexBrowsePathMatcher;
import com.prosysopc.ua.stack.common.NamespaceTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
class RegexBrowsePathMatcher {
    private static final Logger log = LoggerFactory.getLogger(RegexBrowsePathMatcher.class);

    RegexBrowsePathMatcher() {
    }

    static BrowsePathMatchingResult matchRegexBrowsePaths(NamespaceTable namespaceTable, List<Node> addressSpace, String deviceTypeId, Collection<? extends BrowsePathProperty> mappings) {
        if (CollectionUtils.isEmpty(mappings)) {
            return BrowsePathMatchingResult.empty();
        }
        HashMap<String, Node> addressSpaceNodeMap = new HashMap<String, Node>(addressSpace.size());
        HashMap compiledBrowsePathPatterns = new HashMap();
        HashMap matchingTargetNodes = new HashMap();
        HashSet matchingEntries = new HashSet();
        for (Node node : addressSpace) {
            addressSpaceNodeMap.put(node.getNodeId(), node);
            block1: for (BrowsePathProperty browsePathProperty : mappings) {
                Optional pathPatternMaybe = RegexBrowsePathMatcher.getBrowsePathPattern(compiledBrowsePathPatterns, (NamespaceTable)namespaceTable, (BrowsePathProperty)browsePathProperty, (String)deviceTypeId);
                if (!pathPatternMaybe.isPresent()) {
                    return new BrowsePathMatchingResult(Collections.singletonList(browsePathProperty.getBrowsePath()), Collections.emptyList(), Collections.emptyMap());
                }
                for (List nodeAbsPath : node.getAbsolutePaths()) {
                    String nodeAbsPathStr = String.join((CharSequence)"/", nodeAbsPath);
                    Matcher matcher = ((Pattern)pathPatternMaybe.get()).matcher(nodeAbsPathStr);
                    if (!matcher.matches()) continue;
                    List relativePath = nodeAbsPath.subList(nodeAbsPath.size() - browsePathProperty.getBrowsePath().size(), nodeAbsPath.size());
                    RegexBrowsePathMatcher.addToMatchingEntries(matchingTargetNodes, matchingEntries, (Node)node, relativePath, (BrowsePathProperty)browsePathProperty);
                    continue block1;
                }
            }
        }
        if (!matchingEntries.containsAll(mappings)) {
            BrowsePathMatchingResult result = new BrowsePathMatchingResult();
            for (BrowsePathProperty browsePathProperty : mappings) {
                if (matchingEntries.contains(browsePathProperty)) continue;
                result.addNonMatchBrowsePath(browsePathProperty.getBrowsePath());
            }
            if (result.hasNonMatch()) {
                return result;
            }
        }
        log.info("Found {} matching target nodes, searching for matching root nodes...", (Object)matchingTargetNodes.values().stream().mapToInt(Set::size).sum());
        return RegexBrowsePathMatcher.findMatchingRootNodes((String)deviceTypeId, mappings, matchingTargetNodes, addressSpaceNodeMap);
    }

    private static String extractRegex(String browsePath) {
        if (NodeIds.isRegexUsed((String)browsePath)) {
            return browsePath.substring(browsePath.indexOf("(") + 1, browsePath.length() - 1);
        }
        return browsePath;
    }

    private static Optional<Pattern> getBrowsePathPattern(Map<BrowsePathProperty, Pattern> compiledBrowsePathPatterns, NamespaceTable namespaceTable, BrowsePathProperty entry, String deviceTypeId) {
        Optional pathPatternMaybe;
        Pattern pathPattern = compiledBrowsePathPatterns.get(entry);
        if (Objects.isNull(pathPattern) && (pathPatternMaybe = RegexBrowsePathMatcher.compileBrowsePathPattern((NamespaceTable)namespaceTable, (BrowsePathProperty)entry, (String)deviceTypeId)).isPresent()) {
            compiledBrowsePathPatterns.put(entry, (Pattern)pathPatternMaybe.get());
            return pathPatternMaybe;
        }
        return Optional.ofNullable(pathPattern);
    }

    private static Optional<Pattern> compileBrowsePathPattern(NamespaceTable namespaceTable, BrowsePathProperty entry, String deviceTypeId) {
        List browsePath = entry.getBrowsePath();
        ArrayList<String> browsePathPattern = new ArrayList<String>(browsePath.size());
        for (String singlePath : browsePath) {
            if (NodeIds.isRegexUsed((String)singlePath)) {
                browsePathPattern.add(NodeIds.toBrowsePathWithNsUri((NamespaceTable)namespaceTable, (String)RegexBrowsePathMatcher.extractRegex((String)singlePath), (boolean)true));
                continue;
            }
            browsePathPattern.add(Pattern.quote(NodeIds.toBrowsePathWithNsUri((NamespaceTable)namespaceTable, (String)singlePath, (boolean)false)));
        }
        String fullPath = String.join((CharSequence)"/", browsePathPattern);
        try {
            return Optional.of(Pattern.compile(String.format("(.*)/(%s)", fullPath)));
        }
        catch (PatternSyntaxException exception) {
            log.warn("There are invalid regex in your browse path mappings: {}, the device type: {} is considered invalid", (Object)fullPath, (Object)deviceTypeId);
            return Optional.empty();
        }
    }

    private static void addToMatchingEntries(Map<BrowsePathProperty, Set<TargetNode>> matchingTargetNodes, Set<BrowsePathProperty> matchingEntries, Node node, List<String> relativePath, BrowsePathProperty entry) {
        TargetNode targetNode = new TargetNode(node, relativePath);
        if (!matchingTargetNodes.containsKey(entry)) {
            matchingTargetNodes.put(entry, new HashSet());
        }
        matchingTargetNodes.get(entry).add(targetNode);
        matchingEntries.add(entry);
    }

    private static BrowsePathMatchingResult findMatchingRootNodes(String deviceTypeId, Collection<? extends BrowsePathProperty> mappings, Map<BrowsePathProperty, Set<TargetNode>> matchingTargetNodes, Map<String, Node> addressSpaceMap) {
        HashSet allMatchingTargetNodes = new HashSet();
        HashMap potentialMatchingRootNodes = new HashMap();
        for (BrowsePathProperty browsePathProperty : mappings) {
            Set<TargetNode> nodes = matchingTargetNodes.get(browsePathProperty);
            for (TargetNode targetNode : nodes) {
                if (RegexBrowsePathMatcher.findPotentialMatchingRootNode((String)deviceTypeId, allMatchingTargetNodes, potentialMatchingRootNodes, (BrowsePathProperty)browsePathProperty, (TargetNode)targetNode)) continue;
                return BrowsePathMatchingResult.empty();
            }
        }
        HashSet<DeviceTypeMappedNode> result = new HashSet<DeviceTypeMappedNode>();
        Collection collection = mappings.stream().map(BrowsePathProperty::getBrowsePath).collect(Collectors.toSet());
        HashMap<String, Node> matchedNodesMap = new HashMap<String, Node>();
        for (Map.Entry entry : potentialMatchingRootNodes.entrySet()) {
            Collection allTargetNodeBrowsePaths = ((Set)entry.getValue()).stream().map(MappedTargetNode::getMappingBrowsePath).collect(Collectors.toSet());
            if (!allTargetNodeBrowsePaths.containsAll(collection)) continue;
            result.add(DeviceTypeMappedNode.builder().deviceTypeId(deviceTypeId).nodeId((String)entry.getKey()).mappedTargetNodes((Collection)entry.getValue()).build());
            matchedNodesMap.put((String)entry.getKey(), addressSpaceMap.get(entry.getKey()));
        }
        return new BrowsePathMatchingResult(Collections.emptyList(), result, matchedNodesMap);
    }

    private static boolean findPotentialMatchingRootNode(String deviceTypeId, Set<Node> allMatchingTargetNodes, Map<String, Set<MappedTargetNode>> potentialMatchingRootNodes, BrowsePathProperty mappingEntry, TargetNode node) {
        if (!allMatchingTargetNodes.add(node.targetNode)) {
            log.warn("Overlapped (two different mapping browse paths match the same node in the address space), node: {}, ignored device type: {}, please review your device type", (Object)node, (Object)deviceTypeId);
            return false;
        }
        for (List ancestorNodeIds : node.targetNode.getAncestorNodeIds()) {
            if (ancestorNodeIds.size() < mappingEntry.getBrowsePath().size() || mappingEntry.getBrowsePath().size() <= 0) continue;
            String rootNodeId = (String)ancestorNodeIds.get(ancestorNodeIds.size() - mappingEntry.getBrowsePath().size());
            if (!potentialMatchingRootNodes.containsKey(rootNodeId)) {
                potentialMatchingRootNodes.put(rootNodeId, new HashSet());
            }
            potentialMatchingRootNodes.get(rootNodeId).add(new MappedTargetNode(node.relativeBrowsePath, mappingEntry.getBrowsePath(), node.targetNode.getNodeId()));
        }
        return true;
    }
}

