/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.history;

import c8y.ua.command.HistoricDataUploadOperation;
import com.cumulocity.opcua.client.gateway.platform.repository.BinariesRepository;
import com.cumulocity.opcua.common.binary.encoding.BinaryEncodingService;
import com.cumulocity.opcua.common.binary.encoding.model.ChunkCreationResult;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.encoding.EncodingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HistoricDataUploadingService {
    @Autowired
    private BinaryEncodingService binaryEncodingService;
    @Autowired
    private BinariesRepository binariesRepository;

    public List<ManagedObjectRepresentation> uploadHistoryData(DataValue[] dataValues, HistoricDataUploadOperation operation, boolean last, int batch) throws IOException, EncodingException {
        Integer chunkSize = null;
        boolean compress = false;
        if (!Objects.isNull(operation.getChunkSize())) {
            chunkSize = operation.getChunkSize() * 1000000;
        }
        if (!Objects.isNull(operation.getCompress())) {
            compress = operation.getCompress();
        }
        ChunkCreationResult result = this.binaryEncodingService.createChunks(dataValues, chunkSize, compress);
        int currentIndex = 0;
        ArrayList<ManagedObjectRepresentation> createdMOs = new ArrayList<ManagedObjectRepresentation>(result.getChunks());
        while (result.hasNext()) {
            byte[] chunk = result.next();
            String operationId = operation.getOperationId().getValue();
            ManagedObjectRepresentation wrapper = new ManagedObjectRepresentation();
            wrapper.setType("c8y_ua_HistoricData");
            wrapper.setName(String.format("Historic data from operation [%s], batch [%d], chunk [%d]", operationId, batch, currentIndex + 1));
            wrapper.set((Object)operation.getDeviceId(), "c8y_OpcuaServerId");
            wrapper.set((Object)(result.getChunkSize() / 1000000), "inputChunkSize");
            wrapper.set((Object)compress, "deflated");
            wrapper.set((Object)batch, "batch");
            wrapper.set((Object)(currentIndex + 1), "chunk");
            wrapper.set((Object)last, "last");
            wrapper.set((Object)operation.getNodeId(), "nodeId");
            wrapper.set((Object)operationId, "operationId");
            wrapper.set((Object)operation.getDateFrom(), "dateFrom");
            wrapper.set((Object)operation.getDateTo(), "dateTo");
            wrapper.set((Object)operation.getRanges(), "ranges");
            createdMOs.add(this.binariesRepository.uploadFile(wrapper, chunk));
            ++currentIndex;
        }
        return createdMOs;
    }
}

