/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.errorHandler;

import com.cumulocity.opcua.client.gateway.errorHandler.HttpUnauthorizedEvent;
import com.cumulocity.sdk.client.SDKException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.util.ErrorHandler;

public class TaskSchedulerErrorHandler
implements ErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(TaskSchedulerErrorHandler.class);
    private String name;
    private ApplicationEventPublisher applicationEventPublisher;

    public void handleError(Throwable t) {
        if (this.is401SDKException(t)) {
            log.warn("Scheduler {} name caught a 401 exception - triggering internal event", (Object)this.name);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new HttpUnauthorizedEvent((Object)t));
        } else {
            log.error("Error in scheduler {}:", (Object)this.name, (Object)t);
        }
    }

    private boolean is401SDKException(Throwable t) {
        if (!(t instanceof SDKException)) {
            return false;
        }
        SDKException sdkException = (SDKException)t;
        return sdkException.getHttpStatus() == 401;
    }

    public TaskSchedulerErrorHandler(String name, ApplicationEventPublisher applicationEventPublisher) {
        this.name = name;
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

