/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.encryption;

import com.cumulocity.model.authentication.CumulocityBasicCredentials;
import com.cumulocity.model.authentication.CumulocityCredentials;
import com.cumulocity.opcua.client.gateway.datastore.GatewayLocalDatabase;
import com.cumulocity.opcua.client.gateway.datastore.model.EncryptionData;
import com.cumulocity.opcua.client.gateway.encryption.RandomVariablesService;
import com.cumulocity.opcua.client.gateway.platform.configuration.PlatformProvider;
import com.cumulocity.sdk.client.PlatformImpl;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EncryptionService {
    private static final Logger log = LoggerFactory.getLogger(EncryptionService.class);
    private static final String CONNECTION_SALT_KEY = "connectionSalt";
    private static final String INITIALIZATION_VECTOR_KEY = "initializationVector";
    protected static final String SECRET_KEY = "secret";
    public static final int GCM_IV_LENGTH = 12;
    private final GatewayLocalDatabase db;
    private final PlatformProvider platformProvider;

    public static String encryptAESGCM(String secret, String salt, String iv, byte[] data) throws Exception {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        PBEKeySpec keySpec = new PBEKeySpec(secret.toCharArray(), salt.getBytes(), 65536, 256);
        SecretKey secretKey = factory.generateSecret(keySpec);
        SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey.getEncoded(), "AES");
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv.getBytes());
        cipher.init(1, (Key)secretKeySpec, gcmParameterSpec);
        byte[] encrypted = cipher.doFinal(data);
        return Base64.getEncoder().encodeToString(encrypted);
    }

    public static byte[] decryptAESGCM(String secret, String salt, String iv, String data) throws Exception {
        byte[] encryptedMessage = Base64.getDecoder().decode(data);
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        PBEKeySpec keySpec = new PBEKeySpec(secret.toCharArray(), salt.getBytes(), 65536, 256);
        SecretKey secretKey = factory.generateSecret(keySpec);
        SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey.getEncoded(), "AES");
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv.getBytes());
        cipher.init(2, (Key)secretKeySpec, gcmParameterSpec);
        return cipher.doFinal(encryptedMessage);
    }

    public String fetchSalt() {
        EncryptionData encryptionData = this.db.getEncryptionData();
        if (encryptionData.getSalt() == null) {
            try {
                String randomSalt = new RandomVariablesService().generateSecureRandomPassword(2, 2, 4, 2);
                encryptionData.setSalt(randomSalt);
                this.db.setEncryptionData(encryptionData);
                return randomSalt;
            }
            catch (NoSuchAlgorithmException e) {
                log.error("No password found or unable to generate");
                return "";
            }
        }
        return encryptionData.getSalt();
    }

    public String fetchIv() {
        EncryptionData encryptionData = this.db.getEncryptionData();
        if (encryptionData.getInitializationVector() != null) {
            return encryptionData.getInitializationVector();
        }
        try {
            String randomIv = new String(new RandomVariablesService().generateIv(12));
            encryptionData.setInitializationVector(randomIv);
            this.db.setEncryptionData(encryptionData);
            return randomIv;
        }
        catch (NoSuchAlgorithmException e) {
            log.error("No initializationVector found or unable to generate");
            return "";
        }
    }

    public String fetchSecret() throws IllegalStateException {
        String password = this.getPasswordFromCredentials();
        if (password != null) {
            return password;
        }
        EncryptionData encryptionData = this.db.getEncryptionData();
        if (encryptionData.getEncryptedKey() != null) {
            return encryptionData.getEncryptedKey();
        }
        try {
            String randomSecret = new RandomVariablesService().generateSecureRandomPassword(2, 2, 4, 2);
            encryptionData.setEncryptedKey(randomSecret);
            this.db.setEncryptionData(encryptionData);
            return randomSecret;
        }
        catch (NoSuchAlgorithmException e) {
            log.error("No secret found or unable to generate");
            return "";
        }
    }

    private String getPasswordFromCredentials() {
        PlatformImpl platform = (PlatformImpl)this.platformProvider.get();
        CumulocityCredentials credentials = platform.getCumulocityCredentials();
        if (credentials instanceof CumulocityBasicCredentials) {
            return ((CumulocityBasicCredentials)credentials).getPassword();
        }
        return null;
    }

    @Autowired
    public EncryptionService(GatewayLocalDatabase db, PlatformProvider platformProvider) {
        this.db = db;
        this.platformProvider = platformProvider;
    }
}

