/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.datastore.rocksdb;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBSerializer {
    private static final Logger log = LoggerFactory.getLogger(RocksDBSerializer.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    public RocksDBSerializer() {
        this.objectMapper.registerModule((Module)new JodaModule());
    }

    public byte[] serialize(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return this.objectMapper.writeValueAsBytes(object);
        }
        catch (IOException e) {
            log.error("Failed to serialize object of type {}", (Object)object.getClass().getName(), (Object)e);
            throw new RuntimeException("Failed to serialize object", e);
        }
    }

    public <T> T deserialize(byte[] bytes, Class<T> clazz) {
        if (bytes == null) {
            return null;
        }
        try {
            return (T)this.objectMapper.readValue(bytes, clazz);
        }
        catch (IOException e) {
            log.error("Failed to deserialize object of type {}", (Object)clazz.getName(), (Object)e);
            throw new RuntimeException("Failed to deserialize object", e);
        }
    }
}

