/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.cyclicreader.model;

import com.cumulocity.opcua.client.gateway.cyclicreader.model.CyclicReadDefinition;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import java.io.Serializable;
import java.util.Arrays;

public class CyclicReadDefinition
implements Serializable {
    private String serverId;
    private NodeId[] nodeIds;
    private long interval;
    private Double maxAge;
    private String deviceTypeId;
    private String rootNodeId;

    public CyclicReadDefinition(String serverId, NodeId nodeId, long interval, Double maxAge, String deviceTypeId, String rootNodeId) {
        this.serverId = serverId;
        this.nodeIds = new NodeId[]{nodeId};
        this.interval = interval;
        this.maxAge = maxAge;
        this.deviceTypeId = deviceTypeId;
        this.rootNodeId = rootNodeId;
    }

    public CyclicReadDefinition(String serverId, NodeId[] nodeIds, long interval, Double maxAge, String deviceTypeId, String rootNodeId) {
        this.serverId = serverId;
        this.nodeIds = nodeIds;
        this.interval = interval;
        this.maxAge = maxAge;
        this.deviceTypeId = deviceTypeId;
        this.rootNodeId = rootNodeId;
    }

    public static CyclicReadDefinitionBuilder builder() {
        return new CyclicReadDefinitionBuilder();
    }

    public CyclicReadDefinition() {
    }

    public String getServerId() {
        return this.serverId;
    }

    public NodeId[] getNodeIds() {
        return this.nodeIds;
    }

    public long getInterval() {
        return this.interval;
    }

    public Double getMaxAge() {
        return this.maxAge;
    }

    public String getDeviceTypeId() {
        return this.deviceTypeId;
    }

    public String getRootNodeId() {
        return this.rootNodeId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public void setNodeIds(NodeId[] nodeIds) {
        this.nodeIds = nodeIds;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void setMaxAge(Double maxAge) {
        this.maxAge = maxAge;
    }

    public void setDeviceTypeId(String deviceTypeId) {
        this.deviceTypeId = deviceTypeId;
    }

    public void setRootNodeId(String rootNodeId) {
        this.rootNodeId = rootNodeId;
    }

    public String toString() {
        return "CyclicReadDefinition(serverId=" + this.getServerId() + ", nodeIds=" + Arrays.deepToString(this.getNodeIds()) + ", interval=" + this.getInterval() + ", maxAge=" + this.getMaxAge() + ", deviceTypeId=" + this.getDeviceTypeId() + ", rootNodeId=" + this.getRootNodeId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CyclicReadDefinition)) {
            return false;
        }
        CyclicReadDefinition other = (CyclicReadDefinition)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$serverId = this.getServerId();
        String other$serverId = other.getServerId();
        if (this$serverId == null ? other$serverId != null : !this$serverId.equals(other$serverId)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getNodeIds(), other.getNodeIds())) {
            return false;
        }
        String this$deviceTypeId = this.getDeviceTypeId();
        String other$deviceTypeId = other.getDeviceTypeId();
        if (this$deviceTypeId == null ? other$deviceTypeId != null : !this$deviceTypeId.equals(other$deviceTypeId)) {
            return false;
        }
        String this$rootNodeId = this.getRootNodeId();
        String other$rootNodeId = other.getRootNodeId();
        return !(this$rootNodeId == null ? other$rootNodeId != null : !this$rootNodeId.equals(other$rootNodeId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CyclicReadDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serverId = this.getServerId();
        result = result * 59 + ($serverId == null ? 43 : $serverId.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getNodeIds());
        String $deviceTypeId = this.getDeviceTypeId();
        result = result * 59 + ($deviceTypeId == null ? 43 : $deviceTypeId.hashCode());
        String $rootNodeId = this.getRootNodeId();
        result = result * 59 + ($rootNodeId == null ? 43 : $rootNodeId.hashCode());
        return result;
    }
}

