/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.connection.security;

import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.gateway.platform.repository.BinariesRepository;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KeystoreRetriever {
    private final BinariesRepository binariesRepository;

    public byte[] readKeystoreFromBinary(String binaryId) throws IOException {
        try (InputStream in = this.binariesRepository.download(GId.asGId((String)binaryId));){
            byte[] byArray = IOUtils.toByteArray((InputStream)in);
            return byArray;
        }
    }

    @Autowired
    public KeystoreRetriever(BinariesRepository binariesRepository) {
        this.binariesRepository = binariesRepository;
    }
}

