/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.addressspace.service;

import c8y.ua.ClientConfig;
import c8y.ua.Node;
import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.OpcuaClient;
import com.cumulocity.opcua.client.gateway.ServerIdentifier;
import com.cumulocity.opcua.client.gateway.configuration.GatewayGeneralConfiguration;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.prosysopc.ua.stack.core.Identifiers;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AddressSpaceScanEvaluationService {
    private static final Logger log = LoggerFactory.getLogger(AddressSpaceScanEvaluationService.class);
    @Autowired
    private ConnectionManager connectionManager;
    @Autowired
    private GatewayGeneralConfiguration gatewayConfiguration;

    public Set<Node> getStartNodesBasedOnScanType(String serverId) {
        ClientConfig config;
        if (!this.isAutoAddressSpaceScanEnabled(serverId)) {
            log.info("Auto address space scan is disabled");
            return Collections.emptySet();
        }
        HashSet<Node> startNodes = new HashSet<Node>();
        Optional clientConfig = this.getClientConfigByServerId(serverId);
        if (clientConfig.isPresent() && Objects.nonNull((config = (ClientConfig)clientConfig.get()).getPartialAddressScan()) && config.getPartialAddressScan().booleanValue() && Objects.nonNull(config.getPartialAddressScanNodeIds()) && !config.getPartialAddressScanNodeIds().isEmpty()) {
            Optional opcuaClient = this.getOpcuaClientByServerId(serverId);
            for (String nodeId : config.getPartialAddressScanNodeIds()) {
                if (!((OpcuaClient)opcuaClient.get()).doesNodeExist(nodeId)) {
                    log.warn("Unable to find node {} on server {}", (Object)nodeId, (Object)serverId);
                    continue;
                }
                Node node = new Node();
                node.setNodeId(nodeId);
                startNodes.add(node);
            }
        }
        if (startNodes.isEmpty()) {
            startNodes.add(Node.builder().nodeId(Identifiers.RootFolder.toString()).build());
        }
        return startNodes;
    }

    public boolean isAutoAddressSpaceScanEnabled(String serverId) {
        Optional clientConfig = this.getClientConfigByServerId(serverId);
        if (clientConfig.isPresent() && Objects.nonNull(((ClientConfig)clientConfig.get()).getAutoScanAddressSpace())) {
            return ((ClientConfig)clientConfig.get()).getAutoScanAddressSpace();
        }
        return this.gatewayConfiguration.isAutoScanAddressSpace();
    }

    private Optional<ClientConfig> getClientConfigByServerId(String serverId) {
        ServerIdentifier serverIdentifier = new ServerIdentifier(GId.asGId((String)serverId));
        return this.connectionManager.getClientConfig(serverIdentifier);
    }

    private Optional<OpcuaClient> getOpcuaClientByServerId(String serverId) {
        ServerIdentifier serverIdentifier = new ServerIdentifier(GId.asGId((String)serverId));
        return this.connectionManager.getConnection(serverIdentifier);
    }
}

