/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.platform.repository.strategy;

import com.cumulocity.opcua.client.gateway.platform.repository.BaseQueuedRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.interceptor.ProcessingModeContext;
import com.cumulocity.opcua.client.gateway.platform.repository.strategy.BaseFlushExecutor;
import com.cumulocity.opcua.client.gateway.platform.repository.util.ElementQueueOperation;
import com.cumulocity.rest.representation.AbstractExtensibleRepresentation;
import com.cumulocity.sdk.client.ProcessingMode;
import com.cumulocity.sdk.client.SDKException;

public class ProcessingFlushExecutor<T extends AbstractExtensibleRepresentation, Z>
extends BaseFlushExecutor<T, Z> {
    public ProcessingFlushExecutor(BaseQueuedRepository<T, Z> baseQueuedRepository, ElementQueueOperation<T, Z> elementQueueOperation) {
        super(baseQueuedRepository, elementQueueOperation);
    }

    public void executeFlush(Z element, ProcessingMode processingMode) {
        this.baseQueuedRepository.getExecutor().execute(() -> {
            ProcessingModeContext.PMContext.setPM((ProcessingMode)processingMode);
            try {
                this.baseQueuedRepository.createElement(element);
            }
            catch (SDKException e) {
                this.handleException(e, element);
            }
            catch (Exception e) {
                this.handleException(e, element);
            }
            finally {
                ProcessingModeContext.PMContext.remove();
            }
        });
    }
}

