/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.platform.repository;

import com.cumulocity.model.event.CumulocityAlarmStatuses;
import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.gateway.datastore.GatewayLocalDatabase;
import com.cumulocity.opcua.client.gateway.monitoring.QueueMonitoringService;
import com.cumulocity.opcua.client.gateway.platform.repository.BaseQueuedRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.QueuedRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.strategy.FlushExecutor;
import com.cumulocity.opcua.client.gateway.platform.repository.util.ElementQueueOperation;
import com.cumulocity.opcua.client.gateway.platform.repository.util.SingleElementQueueOperation;
import com.cumulocity.rest.representation.alarm.AlarmRepresentation;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.cumulocity.sdk.client.QueryParam;
import com.cumulocity.sdk.client.SDKException;
import com.cumulocity.sdk.client.alarm.AlarmApi;
import com.cumulocity.sdk.client.alarm.AlarmCollection;
import com.cumulocity.sdk.client.alarm.AlarmFilter;
import com.cumulocity.sdk.client.alarm.PagedAlarmCollectionRepresentation;
import com.cumulocity.sdk.client.buffering.Future;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Repository;

@Repository
public class AlarmRepository
extends BaseQueuedRepository<AlarmRepresentation, AlarmRepresentation>
implements AlarmApi,
QueuedRepository<AlarmRepresentation> {
    private static final Logger log = LoggerFactory.getLogger(AlarmRepository.class);
    private final AlarmApi alarmApi;
    @Autowired
    @Qualifier(value="alarmsTaskExecutor")
    private ThreadPoolTaskExecutor executor;
    @Autowired
    private GatewayLocalDatabase db;
    @Autowired
    private final QueueMonitoringService queueMonitoringService;
    private final FlushExecutor<AlarmRepresentation, AlarmRepresentation> singleElementFlushExecutor = new FlushExecutor((ElementQueueOperation)new SingleElementQueueOperation((BaseQueuedRepository)this), (BaseQueuedRepository)this);

    public String getName() {
        return "Alarm Repository";
    }

    public AlarmRepresentation create(GId source, String type, String severity, String text) {
        return this.create(source, type, severity, text, null);
    }

    public AlarmRepresentation create(GId source, String type, String severity, String text, DateTime time) {
        AlarmRepresentation alarm = this.buildAlarm(source, type, severity, text, time);
        try {
            AlarmRepresentation createdAlarm = this.alarmApi.create(alarm);
            this.db.addAlarmCache(source.getValue() + ":" + type, createdAlarm.getId().getValue());
            if (log.isDebugEnabled()) {
                log.debug("Created alarm: " + String.valueOf(createdAlarm));
            }
            return createdAlarm;
        }
        catch (SDKException sdkException) {
            log.error("Could not create alarm, inventory create failed with status {} for alarm {}.", (Object)sdkException.getHttpStatus(), (Object)alarm.getId());
            return new AlarmRepresentation();
        }
    }

    public Future createAsync(GId source, String type, String severity, String text) {
        return this.createAsync(source, type, severity, text, null);
    }

    public Future createAsync(GId source, String type, String severity, String text, DateTime time) {
        AlarmRepresentation alarm = this.buildAlarm(source, type, severity, text, time);
        if (log.isDebugEnabled()) {
            log.debug("Created alarm async: " + String.valueOf(alarm));
        }
        return this.alarmApi.createAsync(alarm);
    }

    public AlarmRepresentation buildAlarm(GId source, String type, String severity, String text, DateTime time) {
        return this.buildAlarm(source, type, severity, null, text, time);
    }

    public AlarmRepresentation buildAlarm(GId source, String type, String severity, String status, String text, DateTime time) {
        ManagedObjectRepresentation sourceMO = new ManagedObjectRepresentation();
        sourceMO.setId(source);
        AlarmRepresentation alarm = new AlarmRepresentation();
        alarm.setType(type);
        alarm.setSource(sourceMO);
        alarm.setText(text);
        alarm.setSeverity(severity);
        alarm.setStatus(status);
        alarm.setDateTime(time == null ? DateTime.now() : time);
        return alarm;
    }

    public AlarmRepresentation acknowledge(String alarmKey, AlarmRepresentation updateAlarm) {
        AlarmRepresentation updatedAlarm = null;
        updateAlarm.setId(GId.asGId((String)this.db.getAlarmCache(alarmKey).orElse(null)));
        updatedAlarm = updateAlarm.getId() != null ? this.alarmApi.update(updateAlarm) : this.alarmApi.create(updateAlarm);
        if (updatedAlarm != null) {
            this.db.addAlarmCache(alarmKey, updatedAlarm.getId().getValue());
            if (log.isDebugEnabled()) {
                log.debug("Updated alarm: " + String.valueOf(updatedAlarm));
            }
        }
        return updatedAlarm;
    }

    public void clearAlarmsByFilter(AlarmFilter alarmFilter) {
        AlarmCollection alarms = this.alarmApi.getAlarmsByFilter(alarmFilter);
        ((PagedAlarmCollectionRepresentation)alarms.get(10000, new QueryParam[0])).allPages().forEach(alarm -> {
            alarm.setStatus(CumulocityAlarmStatuses.CLEARED.name());
            AlarmRepresentation clearedAlarm = this.alarmApi.update(alarm);
            if (clearedAlarm.getSource() != null) {
                this.db.removeAlarmCache(this.generateMapKeyFromAlarm(clearedAlarm));
                if (log.isDebugEnabled()) {
                    log.debug("Cleared alarms by filter" + String.valueOf(alarmFilter));
                }
            }
        });
    }

    public AlarmRepresentation clear(String alarmKey) {
        String alarmId = this.db.getAlarmCache(alarmKey).orElse(null);
        if (alarmId != null) {
            AlarmRepresentation alarm = new AlarmRepresentation();
            alarm.setId(GId.asGId((String)alarmId));
            alarm.setStatus(CumulocityAlarmStatuses.CLEARED.name());
            try {
                AlarmRepresentation clearedAlarm = this.alarmApi.update(alarm);
                this.db.removeAlarmCache(alarmKey);
                if (log.isDebugEnabled()) {
                    log.debug("Cleared alarm: " + String.valueOf(clearedAlarm));
                }
                return clearedAlarm;
            }
            catch (SDKException sdkException) {
                log.error("Could not clear alarm {}, inventory update failed.", (Object)alarmId);
            }
        }
        return new AlarmRepresentation();
    }

    public AlarmRepresentation clear(GId alarmId) {
        AlarmRepresentation alarm = new AlarmRepresentation();
        alarm.setId(alarmId);
        alarm.setStatus(CumulocityAlarmStatuses.CLEARED.name());
        try {
            AlarmRepresentation clearedAlarm = this.alarmApi.update(alarm);
            if (clearedAlarm.getSource() != null) {
                this.db.removeAlarmCache(this.generateMapKeyFromAlarm(clearedAlarm));
                if (log.isDebugEnabled()) {
                    log.debug("Cleared alarm: " + String.valueOf(clearedAlarm));
                }
            }
            return clearedAlarm;
        }
        catch (SDKException sdkException) {
            log.error("Could not clear alarm {}, inventory update failed.", (Object)alarmId);
            return new AlarmRepresentation();
        }
    }

    public void createElement(AlarmRepresentation alarm) {
        try {
            AlarmRepresentation createdAlarm = this.alarmApi.create(alarm);
            this.db.addAlarmCache(this.generateMapKeyFromAlarm(createdAlarm), createdAlarm.getId().getValue());
            if (log.isDebugEnabled()) {
                log.debug("Created alarm: " + String.valueOf(createdAlarm));
            }
        }
        catch (SDKException sdkException) {
            log.error("Could not create alarm, inventory create failed with status {} for alarm {}.", (Object)sdkException.getHttpStatus(), (Object)alarm.getId());
        }
    }

    protected FlushExecutor<AlarmRepresentation, AlarmRepresentation> getFlushStrategy() {
        return this.singleElementFlushExecutor;
    }

    public int getActiveThreads() {
        return this.executor.getActiveCount();
    }

    public int getQueuedThreads() {
        return this.executor.getThreadPoolExecutor().getQueue().size();
    }

    public GId getElementSource(AlarmRepresentation element) {
        return element.getSource() != null ? element.getSource().getId() : null;
    }

    public ThreadPoolTaskExecutor getExecutor() {
        return this.executor;
    }

    public void reportExecutor() {
        this.queueMonitoringService.report("AlarmRepository", Integer.valueOf(this.executor.getThreadPoolExecutor().getQueue().size()));
    }

    private String generateMapKeyFromAlarm(AlarmRepresentation alarm) {
        return alarm.getSource().getId().getValue() + ":" + alarm.getType();
    }

    @Autowired
    public AlarmRepository(AlarmApi alarmApi, QueueMonitoringService queueMonitoringService) {
        this.alarmApi = alarmApi;
        this.queueMonitoringService = queueMonitoringService;
    }

    public void setExecutor(ThreadPoolTaskExecutor executor) {
        this.executor = executor;
    }

    public void setDb(GatewayLocalDatabase db) {
        this.db = db;
    }

    public AlarmRepresentation getAlarm(GId arg0) throws SDKException {
        return this.alarmApi.getAlarm(arg0);
    }

    public AlarmRepresentation create(AlarmRepresentation arg0) throws SDKException {
        return this.alarmApi.create(arg0);
    }

    public Future createAsync(AlarmRepresentation arg0) throws SDKException {
        return this.alarmApi.createAsync(arg0);
    }

    public AlarmRepresentation update(AlarmRepresentation arg0) throws SDKException {
        return this.alarmApi.update(arg0);
    }

    public AlarmCollection getAlarms() throws SDKException {
        return this.alarmApi.getAlarms();
    }

    public AlarmCollection getAlarmsByFilter(AlarmFilter arg0) throws SDKException {
        return this.alarmApi.getAlarmsByFilter(arg0);
    }

    public void deleteAlarmsByFilter(AlarmFilter arg0) throws IllegalArgumentException, SDKException {
        this.alarmApi.deleteAlarmsByFilter(arg0);
    }

    @Deprecated
    public AlarmRepresentation updateAlarm(AlarmRepresentation arg0) throws SDKException {
        return this.alarmApi.updateAlarm(arg0);
    }
}

