/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.operation.handler;

import c8y.Command;
import c8y.ua.command.GetDeviceTypeApplicationState;
import com.cumulocity.opcua.client.gateway.GatewayManager;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.operation.handler.base.HandleInternalResult;
import com.cumulocity.opcua.client.gateway.operation.handler.base.UAServerOperationHandler;
import com.cumulocity.opcua.client.gateway.subscription.model.SubscribedNode;
import com.cumulocity.opcua.client.gateway.subscription.repository.SubscriptionRepository;
import com.cumulocity.opcua.client.serialization.OpcuaSerializer;
import com.cumulocity.sdk.client.devicecontrol.DeviceControlApi;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class GetDeviceTypeApplicationStateOperationHandler
extends UAServerOperationHandler<GetDeviceTypeApplicationState> {
    private final SubscriptionRepository subscriptionRepository;

    @Autowired
    public GetDeviceTypeApplicationStateOperationHandler(GatewayManager gatewayManager, ConnectionManager connectionManager, DeviceControlApi deviceControlApi, SubscriptionRepository subscriptionRepository) {
        super(gatewayManager, connectionManager, GetDeviceTypeApplicationState.class, deviceControlApi);
        this.subscriptionRepository = subscriptionRepository;
    }

    protected HandleInternalResult handleInternal(GetDeviceTypeApplicationState operation) {
        Map<String, Boolean> appliedNodes;
        Collection serverSubscribedNodes = this.subscriptionRepository.getSubscribedNodes(operation.getDeviceId().getValue());
        if (CollectionUtils.isEmpty((Collection)operation.getMatchingRootNodes())) {
            appliedNodes = serverSubscribedNodes.stream().filter(node -> this.isTypeOf(node, operation.getDeviceTypeId())).collect(Collectors.toMap(SubscribedNode::getRootNodeId, subscribedNode -> true));
        } else {
            Set allAppliedNodes = serverSubscribedNodes.stream().filter(node -> this.isTypeOf(node, operation.getDeviceTypeId())).map(SubscribedNode::getRootNodeId).collect(Collectors.toSet());
            appliedNodes = operation.getMatchingRootNodes().stream().collect(Collectors.toMap(node -> node, allAppliedNodes::contains));
        }
        Command commandResult = new Command();
        commandResult.setResult(OpcuaSerializer.getInstance().toJson(appliedNodes));
        return new HandleInternalResult(commandResult, true, null);
    }

    private boolean isTypeOf(SubscribedNode node, String deviceTypeId) {
        return StringUtils.isEmpty((Object)deviceTypeId) || deviceTypeId.equals(node.getDeviceTypeId());
    }
}

