/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.notification;

import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.gateway.configuration.GatewayGeneralConfiguration;
import com.cumulocity.opcua.client.gateway.connection.model.DeviceCreatedEvent;
import com.cumulocity.opcua.client.gateway.connection.model.ServerConnectedEvent;
import com.cumulocity.opcua.client.gateway.connection.model.ServerDisconnectedEvent;
import com.cumulocity.opcua.client.gateway.operation.OperationExecutor;
import com.cumulocity.opcua.client.gateway.platform.configuration.PlatformProvider;
import com.cumulocity.opcua.client.serialization.OpcuaSerializer;
import com.cumulocity.rest.representation.inventory.ManagedObjectReferenceRepresentation;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.cumulocity.rest.representation.operation.OperationCollectionRepresentation;
import com.cumulocity.rest.representation.operation.OperationRepresentation;
import com.cumulocity.sdk.client.RestConnector;
import com.cumulocity.sdk.client.inventory.InventoryApi;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ShortPollingOperationSubscriber
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ShortPollingOperationSubscriber.class);
    @Autowired
    private GatewayGeneralConfiguration configuration;
    @Autowired
    private PlatformProvider platformProvider;
    @Autowired
    private OperationExecutor operationExecutor;
    @Autowired
    private InventoryApi inventoryApi;
    @Autowired
    private TaskScheduler scheduler;
    private Collection<GId> subscribedDevices = Collections.newSetFromMap(new ConcurrentHashMap());

    @EventListener
    public void subscribeForOperations(ServerConnectedEvent serverConnectedEvent) {
        if (this.configuration.isShortPollingEnabled()) {
            log.info("Subscribing for operations of device {} [short polling]", (Object)serverConnectedEvent.getServerIdentifier().getInventoryIdentifier().getValue());
            this.subscribedDevices.add(serverConnectedEvent.getServerIdentifier().getInventoryIdentifier());
            ManagedObjectRepresentation serverRepresentation = this.inventoryApi.get(serverConnectedEvent.getServerIdentifier().getInventoryIdentifier());
            if (serverRepresentation != null) {
                List childDevices = serverRepresentation.getChildDevices().getReferences();
                for (ManagedObjectReferenceRepresentation childDevice : childDevices) {
                    log.info("Subscribing for operations of child device {} [short polling]", (Object)childDevice.getManagedObject().getId());
                    this.subscribedDevices.add(childDevice.getManagedObject().getId());
                }
            }
        }
    }

    @EventListener
    public void unsubscribeForOperations(ServerDisconnectedEvent serverDisconnectedEvent) {
        if (this.configuration.isShortPollingEnabled()) {
            log.info("Unsubscribing for operations of device {} [short polling]", (Object)serverDisconnectedEvent.getServerIdentifier().getInventoryIdentifier().getValue());
            this.subscribedDevices.remove(serverDisconnectedEvent.getServerIdentifier().getInventoryIdentifier());
            ManagedObjectRepresentation serverRepresentation = this.inventoryApi.get(serverDisconnectedEvent.getServerIdentifier().getInventoryIdentifier());
            if (serverRepresentation != null) {
                List childDevices = serverRepresentation.getChildDevices().getReferences();
                for (ManagedObjectReferenceRepresentation childDevice : childDevices) {
                    log.info("Unsubscribing for operations of child device {} [short polling]", (Object)childDevice.getManagedObject().getId());
                    this.subscribedDevices.remove(childDevice.getManagedObject().getId());
                }
            }
        }
    }

    @EventListener
    public void subscribeForOperations(DeviceCreatedEvent deviceCreatedEvent) {
        if (this.configuration.isShortPollingEnabled()) {
            log.info("Subscribing for operations of device {} [short polling]", (Object)deviceCreatedEvent.getDeviceId());
            this.subscribedDevices.add(GId.asGId((String)deviceCreatedEvent.getDeviceId()));
        }
    }

    public void afterPropertiesSet() {
        if (this.configuration.isShortPollingEnabled()) {
            log.info("Short polling is enabled, scheduling short polling for operations with fixed delay {} ms", (Object)this.configuration.getShortPollingFixedDelayMils());
            this.scheduler.scheduleWithFixedDelay(() -> this.poll(), this.configuration.getShortPollingFixedDelayMils());
        }
    }

    private void poll() {
        for (GId deviceId : this.subscribedDevices) {
            try {
                this.fetchPendingOperationsOnDevice(deviceId);
            }
            catch (IOException e) {
                log.error("Couldn't read operations for device " + deviceId.getValue(), (Throwable)e);
            }
        }
    }

    private void fetchPendingOperationsOnDevice(GId deviceId) throws IOException {
        log.debug("Short polling pending operations for device: " + deviceId.getValue());
        String url = "/devicecontrol/operations?status=PENDING&deviceId=" + deviceId.getValue() + "&pageSize=1000";
        RestConnector restConnector = (RestConnector)this.platformProvider.get().rest();
        Response clientResponse = restConnector.get(url, MediaType.APPLICATION_JSON_TYPE);
        String jsonResponse = IOUtils.toString((InputStream)((InputStream)clientResponse.readEntity(InputStream.class)));
        log.debug("Pending operations JSON: \n" + jsonResponse);
        this.parseOperations(jsonResponse);
    }

    private void parseOperations(String json) {
        OpcuaSerializer serializer = OpcuaSerializer.getInstance();
        List operations = ((OperationCollectionRepresentation)serializer.fromJson(json, OperationCollectionRepresentation.class)).getOperations();
        if (CollectionUtils.isEmpty((Collection)operations)) {
            return;
        }
        log.debug("Found " + operations.size() + " operations");
        for (OperationRepresentation operation : operations) {
            this.operationExecutor.submit(this.outdate(operation));
        }
    }

    private OperationRepresentation outdate(OperationRepresentation operation) {
        operation.setCreationDateTime(DateTime.now().minusMinutes(10));
        return operation;
    }
}

