/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.monitoring;

import c8y.Firmware;
import com.cumulocity.model.event.CumulocityAlarmStatuses;
import com.cumulocity.model.event.CumulocitySeverities;
import com.cumulocity.model.idtype.GId;
import com.cumulocity.model.measurement.MeasurementValue;
import com.cumulocity.opcua.client.gateway.GatewayManager;
import com.cumulocity.opcua.client.gateway.ServerIdentifier;
import com.cumulocity.opcua.client.gateway.bootstrap.model.BootstrapReadyEvent;
import com.cumulocity.opcua.client.gateway.configuration.GatewayGeneralConfiguration;
import com.cumulocity.opcua.client.gateway.configuration.InventoryUpdateProcessingModeConfiguration;
import com.cumulocity.opcua.client.gateway.cyclicreader.CyclicReadExecutor;
import com.cumulocity.opcua.client.gateway.jmx.ServerMonitoringMBean;
import com.cumulocity.opcua.client.gateway.mappingsexecution.HttpPostQueue;
import com.cumulocity.opcua.client.gateway.mappingsexecution.MappingsExecutor;
import com.cumulocity.opcua.client.gateway.monitoring.ConnectionMonitoringService;
import com.cumulocity.opcua.client.gateway.platform.configuration.PlatformProvider;
import com.cumulocity.opcua.client.gateway.platform.repository.AlarmRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.EventRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.MeasurementRepository;
import com.cumulocity.opcua.client.gateway.subscription.repository.SubscriptionRepository;
import com.cumulocity.opcua.common.repository.InventoryRepository;
import com.cumulocity.rest.representation.AbstractExtensibleRepresentation;
import com.cumulocity.rest.representation.alarm.AlarmRepresentation;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.cumulocity.rest.representation.measurement.MeasurementRepresentation;
import com.cumulocity.sdk.client.SDKException;
import com.cumulocity.sdk.client.alarm.AlarmApi;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Service;

@Service
public class GatewayMonitoringService {
    private static final Logger log = LoggerFactory.getLogger(GatewayMonitoringService.class);
    public static final String GATEWAY_OVERLOAD_ALARM_TYPE = "c8y_ua_GatewayOverload";
    public static final String MEASUREMENT_REPOSITORY = "Measurement Repository";
    public static final String EVENT_REPOSITORY = "Event Repository";
    public static final String ALARM_REPOSITORY = "Alarm Repository";
    public static final String HTTP_QUEUE = "HTTP Queue";
    @Autowired
    private GatewayGeneralConfiguration configuration;
    @Autowired
    private EventRepository eventRepository;
    @Autowired
    private AlarmRepository alarmRepository;
    @Autowired
    private HttpPostQueue httpPostQueue;
    @Autowired
    private MeasurementRepository measurementRepository;
    @Autowired
    @Qualifier(value="pmAwareInventoryRepository")
    private InventoryRepository inventoryRepository;
    @Autowired
    private GatewayManager gatewayManager;
    @Autowired
    private ServerMonitoringMBean mbean;
    @Autowired
    private ThreadPoolTaskScheduler taskScheduler;
    @Autowired
    private MappingsExecutor mappingsExecutor;
    @Autowired
    private CyclicReadExecutor cyclicReadExecutor;
    @Autowired
    private PlatformProvider platformProvider;
    @Autowired
    private ConnectionMonitoringService connectionMonitoring;
    @Autowired
    private SubscriptionRepository subscriptionRepository;
    @Autowired
    private AlarmApi alarmApi;
    @Autowired
    private InventoryUpdateProcessingModeConfiguration processingModeConfiguration;
    @Value(value="${gateway.version}")
    private String gatewayVersion;
    @Value(value="${gateway.repositories.maximumCapacity:250000}")
    private int maxCapacity;
    @Value(value="${gateway.repositories.reenableThresholdSize:10}")
    private int reenableThreshold;
    private GId gatewayMOId;
    private AlarmRepresentation alarmRepresentation = null;

    @EventListener
    public void onBootstrapReady(BootstrapReadyEvent bootstrapReadyEvent) {
        ManagedObjectRepresentation gatewayMO = bootstrapReadyEvent.getGatewayDevice();
        this.gatewayMOId = gatewayMO.getId();
        this.eventRepository.createEvent(this.gatewayMOId, "c8y_ua_GatewayStarted", String.format("Gateway [%s, %s] started", this.configuration.getGatewayIdentifier(), this.configuration.getGatewayName()));
    }

    @Scheduled(fixedRateString="${gateway.monitoring.interval}", initialDelay=20000L)
    public void monitorGatewayInstance() {
        block4: {
            if (!this.platformProvider.isCredentialsAvailable()) {
                log.info("No platform credentials are available. Skipping sending monitoring information.");
                return;
            }
            if (Objects.isNull(this.gatewayMOId)) {
                log.debug("Gateway is not ready, skip sending monitoring data.");
                return;
            }
            try {
                this.setApplicationVersion();
                this.addRepositoriesQueueSizeMeasurements();
                this.addThreadPoolMeasurements();
                this.addReaderMeasurements();
                this.addJvmMeasurements();
                this.addResponseTimes();
                this.addConnectedServers();
            }
            catch (Exception exception) {
                log.warn("Unable to send monitoring data, reason: {}", (Object)exception.getMessage());
                if (!log.isDebugEnabled()) break block4;
                log.debug("Details: ", (Throwable)exception);
            }
        }
    }

    @Scheduled(fixedRateString="${gateway.monitoring.checkQueueSizes}", initialDelay=20000L)
    void checkQueueCapacities() {
        int alarmQueueSize = this.alarmRepository.getItemsWaitingToFlush();
        int eventQueueSize = this.eventRepository.getItemsWaitingToFlush();
        int measurementQueueSize = this.measurementRepository.getItemsWaitingToFlush();
        long httpPostQueueSize = this.httpPostQueue.getQueueSize();
        log.info("Items left to flush: Measurements {}, Events {}, Alarms {}, MaxCapacity: {}", new Object[]{measurementQueueSize, eventQueueSize, alarmQueueSize, this.maxCapacity});
        log.info("Items left to flush: HttpPostQueue {}, MaxCapacity: {}", (Object)httpPostQueueSize, (Object)this.httpPostQueue.getQueueBufferMaxSize());
        if (!this.gatewayManager.isOpcuaConnectionDisabled()) {
            this.disableOPCUAIfQueuesTooLarge();
        } else {
            this.reactivateOPCUACommunication();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reactivateOPCUACommunication() {
        boolean allReposHealthyAgain;
        boolean measurementRepoHealthy = false;
        boolean eventRepoHealthy = false;
        boolean alarmRepoHealthy = false;
        boolean httpPostQueueHealthy = false;
        int alarmQueueSize = this.alarmRepository.getItemsWaitingToFlush();
        int eventQueueSize = this.eventRepository.getItemsWaitingToFlush();
        int measurementQueueSize = this.measurementRepository.getItemsWaitingToFlush();
        long httpPostQueueSize = this.httpPostQueue.getQueueSize();
        if (measurementQueueSize <= this.reenableThreshold) {
            log.debug("Measurement Repository below reactivation threshold");
            measurementRepoHealthy = true;
        }
        if (eventQueueSize <= this.reenableThreshold) {
            log.debug("Event Repository below reactivation threshold");
            eventRepoHealthy = true;
        }
        if (alarmQueueSize <= this.reenableThreshold) {
            log.debug("Alarm Repository below reactivation threshold");
            alarmRepoHealthy = true;
        }
        if (httpPostQueueSize <= (long)this.reenableThreshold) {
            log.debug("Http Post Queue below reactivation threshold");
            httpPostQueueHealthy = true;
        }
        boolean bl = allReposHealthyAgain = measurementRepoHealthy && eventRepoHealthy && alarmRepoHealthy && httpPostQueueHealthy;
        if (allReposHealthyAgain) {
            log.info("All Repositories are below the reactivation threshold. Re-enabling OPC UA Server communication");
            if (this.alarmRepresentation != null) {
                AlarmRepresentation alarm = new AlarmRepresentation();
                alarm.setId(this.alarmRepresentation.getId());
                alarm.setStatus(CumulocityAlarmStatuses.CLEARED.name());
                try {
                    this.alarmRepresentation = this.alarmApi.update(alarm);
                    log.debug("All repos are healthy. Alarm cleared: {}", (Object)this.alarmRepresentation);
                }
                catch (SDKException e) {
                    GId alarmId = Objects.isNull(alarm) ? null : this.alarmRepresentation.getId();
                    log.error("Failed to clear alarm: {}, inventory update status: {}, exception message: {}", new Object[]{alarmId, e.getHttpStatus(), e.getMessage()});
                }
                finally {
                    this.alarmRepresentation = null;
                }
            }
            this.gatewayManager.enableOPCUACommunication();
            log.info("Reestablishing subscriptions");
        }
    }

    private void disableOPCUAIfQueuesTooLarge() {
        int alarmQueueSize = this.alarmRepository.getItemsWaitingToFlush();
        int eventQueueSize = this.eventRepository.getItemsWaitingToFlush();
        int measurementQueueSize = this.measurementRepository.getItemsWaitingToFlush();
        String overflowedQueue = null;
        boolean mustDisableOPCUACommunication = false;
        if (measurementQueueSize > this.maxCapacity) {
            log.warn("Measurement Repository has reached maximum capacity!");
            overflowedQueue = MEASUREMENT_REPOSITORY;
            mustDisableOPCUACommunication = true;
        }
        if (eventQueueSize > this.maxCapacity) {
            log.warn("Event Repository has reached maximum capacity!");
            overflowedQueue = EVENT_REPOSITORY;
            mustDisableOPCUACommunication = true;
        }
        if (alarmQueueSize > this.maxCapacity) {
            log.warn("Alarm Repository has reached maximum capacity!");
            overflowedQueue = ALARM_REPOSITORY;
            mustDisableOPCUACommunication = true;
        }
        if (this.httpPostQueue.getQueueSize() > (long)this.httpPostQueue.getQueueBufferMaxSize()) {
            log.warn("Http Post Queue has reached maximum capacity!");
            overflowedQueue = HTTP_QUEUE;
            mustDisableOPCUACommunication = true;
        }
        if (mustDisableOPCUACommunication) {
            log.warn("Disabling all OPC UA Communication to prevent running out of memory. We will now miss data from the OPC UA server");
            if (this.alarmRepresentation == null) {
                AlarmRepresentation alarm = this.alarmRepository.buildAlarm(this.gatewayMOId, GATEWAY_OVERLOAD_ALARM_TYPE, CumulocitySeverities.CRITICAL.name(), overflowedQueue + " overflowed. Disabling OPC UA Server communication", null);
                try {
                    this.alarmRepresentation = this.alarmApi.create(alarm);
                    log.debug("{} overflowed. Alarm created: {}", (Object)overflowedQueue, (Object)this.alarmRepresentation);
                }
                catch (SDKException e) {
                    GId alarmId = Objects.isNull(alarm) ? null : this.alarmRepresentation.getId();
                    log.error("Failed to create alarm: {}, inventory create status: {}, exception message: {}", new Object[]{alarmId, e.getHttpStatus(), e.getMessage()});
                }
            }
            this.gatewayManager.disableOPCUACommunication();
        }
    }

    private void setApplicationVersion() {
        ManagedObjectRepresentation gatewayMo = new ManagedObjectRepresentation();
        gatewayMo.setId(this.gatewayMOId);
        Firmware firmware = new Firmware("Cumulocity OPC-UA Gateway", this.gatewayVersion, "");
        gatewayMo.set((Object)firmware);
        this.inventoryRepository.update(gatewayMo, this.processingModeConfiguration.getGatewayUpdateProcessingMode());
    }

    @NotNull
    private MeasurementRepresentation createMeasurementRepresentation(String c8y_opcuaGatewayRepositoryQueues) {
        MeasurementRepresentation measurement = new MeasurementRepresentation();
        ManagedObjectRepresentation source = new ManagedObjectRepresentation();
        source.setId(this.gatewayMOId);
        measurement.setSource(source);
        measurement.setDateTime(DateTime.now());
        measurement.setType(c8y_opcuaGatewayRepositoryQueues);
        return measurement;
    }

    @NotNull
    private MeasurementValue createMeasurementValue(String unit, BigDecimal value) {
        MeasurementValue mv = new MeasurementValue();
        mv.setUnit(unit);
        if (value.compareTo(BigDecimal.valueOf(Long.MAX_VALUE)) > 0 || value.compareTo(BigDecimal.valueOf(Long.MIN_VALUE)) < 0) {
            mv.setValue(BigDecimal.valueOf(value.doubleValue()));
        } else {
            mv.setValue(value);
        }
        return mv;
    }

    private void addRepositoriesQueueSizeMeasurements() {
        MeasurementRepresentation measurement = this.createMeasurementRepresentation("c8y_gatewayRepositoryQueues");
        HashMap<String, MeasurementValue> series = new HashMap<String, MeasurementValue>();
        series.put("measurement_queue", this.createMeasurementValue("measurements", new BigDecimal(this.measurementRepository.getQueueSize())));
        series.put("event_queue", this.createMeasurementValue("events", new BigDecimal(this.eventRepository.getQueueSize())));
        series.put("alarm_queue", this.createMeasurementValue("alarms", new BigDecimal(this.alarmRepository.getQueueSize())));
        measurement.setProperty(measurement.getType(), series);
        this.measurementRepository.create(measurement);
    }

    private void addThreadPoolMeasurements() {
        MeasurementRepresentation measurement = this.createMeasurementRepresentation("c8y_gatewayActiveThreads");
        HashMap<String, MeasurementValue> series = new HashMap<String, MeasurementValue>();
        series.put("event_flush", this.createMeasurementValue("threads", new BigDecimal(this.eventRepository.getActiveThreads())));
        series.put("alarm_flush", this.createMeasurementValue("threads", new BigDecimal(this.alarmRepository.getActiveThreads())));
        series.put("measurement_flush", this.createMeasurementValue("threads", new BigDecimal(this.measurementRepository.getActiveThreads())));
        series.put("event_flush_queued", this.createMeasurementValue("threads", new BigDecimal(this.eventRepository.getQueuedThreads())));
        series.put("alarm_flush_queued", this.createMeasurementValue("threads", new BigDecimal(this.alarmRepository.getQueuedThreads())));
        series.put("measurement_flush_queued", this.createMeasurementValue("threads", new BigDecimal(this.measurementRepository.getQueuedThreads())));
        series.put("executor", this.createMeasurementValue("threads", new BigDecimal(this.mappingsExecutor.getActiveThreads())));
        series.put("scheduler", this.createMeasurementValue("threads", new BigDecimal(this.taskScheduler.getActiveCount())));
        measurement.setProperty(measurement.getType(), series);
        this.measurementRepository.create(measurement);
    }

    private void addReaderMeasurements() {
        MeasurementRepresentation measurement = this.createMeasurementRepresentation("c8y_gatewayCyclicReads");
        HashMap<String, MeasurementValue> series = new HashMap<String, MeasurementValue>();
        series.put("scheduled_reads", this.createMeasurementValue("scheduled", new BigDecimal(this.cyclicReadExecutor.getScheduledReadsCount())));
        series.put("active_reads", this.createMeasurementValue("threads", new BigDecimal(this.cyclicReadExecutor.getActiveThreads())));
        series.put("avg_interval", this.createMeasurementValue("ms", new BigDecimal(this.cyclicReadExecutor.getAvgInterval())));
        measurement.setProperty(measurement.getType(), series);
        this.measurementRepository.create(measurement);
    }

    private void addJvmMeasurements() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory() / 0x100000L;
        long allocatedMemory = runtime.totalMemory() / 0x100000L;
        long freeMemory = runtime.freeMemory() / 0x100000L;
        MeasurementRepresentation measurement = this.createMeasurementRepresentation("c8y_gatewayMemory");
        HashMap<String, MeasurementValue> series = new HashMap<String, MeasurementValue>();
        series.put("max", this.createMeasurementValue("MB", new BigDecimal(maxMemory)));
        series.put("allocated", this.createMeasurementValue("MB", new BigDecimal(allocatedMemory)));
        series.put("free", this.createMeasurementValue("MB", new BigDecimal(freeMemory)));
        measurement.setProperty(measurement.getType(), series);
        this.measurementRepository.create(measurement);
    }

    private void addResponseTimes() {
        if (this.gatewayManager.getGatewayDetails() != null && this.gatewayManager.getGatewayDetails().getServerIdentifiers() != null) {
            log.debug("Checking server response times");
            MeasurementRepresentation measurement = this.createMeasurementRepresentation("c8y_serverResponseTime");
            HashMap<String, MeasurementValue> series = new HashMap<String, MeasurementValue>();
            for (ServerIdentifier si : this.gatewayManager.getGatewayDetails().getServerIdentifiers()) {
                log.debug("Checking server: " + String.valueOf(si));
                BigDecimal responseTime = this.connectionMonitoring.takeServerResponseTime(si.getInventoryIdentifier().getValue());
                if (!Objects.nonNull(responseTime)) continue;
                this.addResponseTimeToServer(si, responseTime);
                series.put(si.getName(), this.createMeasurementValue("ms", responseTime));
            }
            if (!series.isEmpty()) {
                measurement.setProperty(measurement.getType(), series);
                this.measurementRepository.create(measurement);
            }
        }
    }

    private void addResponseTimeToServer(ServerIdentifier serverIdentifier, BigDecimal responseTime) {
        MeasurementRepresentation measurement = this.createMeasurementRepresentation("c8y_serverResponseTime");
        ManagedObjectRepresentation source = new ManagedObjectRepresentation();
        source.setId(serverIdentifier.getInventoryIdentifier());
        measurement.setSource(source);
        HashMap<String, MeasurementValue> series = new HashMap<String, MeasurementValue>();
        series.put("response_time", this.createMeasurementValue("ms", responseTime));
        measurement.setProperty(measurement.getType(), series);
        this.measurementRepository.addToQueue((AbstractExtensibleRepresentation)measurement);
    }

    private void addConnectedServers() {
        MeasurementRepresentation measurement = this.createMeasurementRepresentation("c8y_connectedServers");
        int connected = 0;
        int disconnected = 0;
        Map connectionStatusMap = this.mbean.getConnectionStatusMap();
        for (String server : connectionStatusMap.keySet()) {
            if (((Boolean)connectionStatusMap.get(server)).booleanValue()) {
                ++connected;
                continue;
            }
            ++disconnected;
        }
        HashMap<String, MeasurementValue> series = new HashMap<String, MeasurementValue>();
        series.put("connected servers", this.createMeasurementValue("num", new BigDecimal(connected)));
        series.put("disconnected servers", this.createMeasurementValue("num", new BigDecimal(disconnected)));
        measurement.setProperty(measurement.getType(), series);
        this.measurementRepository.create(measurement);
    }

    public void setMaxCapacity(int maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    public void setReenableThreshold(int reenableThreshold) {
        this.reenableThreshold = reenableThreshold;
    }
}

