/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappingsexecution.tasks;

import com.cumulocity.model.event.CumulocitySeverities;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.BaseTask;
import com.cumulocity.opcua.client.gateway.platform.repository.ThinEdgeAlarmRepository;
import com.cumulocity.opcua.common.model.mapping.action.HttpPostAction;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ThinEdgeCustomActionTask
extends BaseTask {
    private static final Logger log = LoggerFactory.getLogger(ThinEdgeCustomActionTask.class);
    @Autowired
    private MqttClient mqttClient;
    private HttpPostAction customAction;
    @Autowired
    private ThinEdgeAlarmRepository alarmRepository;

    public void run() {
        try {
            String topic = this.customAction.getEndpoint();
            MqttMessage message = new MqttMessage();
            message.setPayload(this.payload().getBytes());
            this.mqttClient.publish(topic, message);
        }
        catch (MqttException e) {
            this.alarmRepository.create(this.getDeviceId(), "opcuaMqttPublishFailed", CumulocitySeverities.MAJOR.name(), "Failed to publish MQTT message: " + e.getMessage());
            log.error("Failed to publish MQTT message: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private String payload() {
        return this.customAction.getBodyTemplate().replaceAll("\\$\\{value}", this.getValueAsJsonString()).replaceAll("\\$\\{serverId}", this.getEvent().getServerId()).replaceAll("\\$\\{nodeId}", this.getEvent().getNodeId()).replaceAll("\\$\\{deviceId}", this.getDeviceId().getValue()).replaceAll("\\$\\{receivedTimestampInMs}", String.valueOf(DateTime.now().getMillis()));
    }

    public void setMqttClient(MqttClient mqttClient) {
        this.mqttClient = mqttClient;
    }

    public void setAlarmRepository(ThinEdgeAlarmRepository alarmRepository) {
        this.alarmRepository = alarmRepository;
    }

    public void setCustomAction(HttpPostAction customAction) {
        this.customAction = customAction;
    }
}

