/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappingsexecution.tasks;

import com.cumulocity.model.event.CumulocitySeverities;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.BaseBatchTask;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.TaskUtils;
import com.cumulocity.opcua.client.gateway.platform.repository.ThinEdgeAlarmRepository;
import com.cumulocity.opcua.client.serialization.OpcuaSerializer;
import com.cumulocity.opcua.common.model.mapping.action.EventCreation;
import com.cumulocity.opcua.common.model.mapping.action.MappingAction;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ThinEdgeBatchEventCreationTask
extends BaseBatchTask {
    private static final Logger log = LoggerFactory.getLogger(ThinEdgeBatchEventCreationTask.class);
    @Autowired
    private MqttClient mqttClient;
    @Autowired
    private ThinEdgeAlarmRepository alarmRepository;

    public void run() {
        try {
            HashMap<String, String> teEvent = new HashMap<String, String>();
            teEvent.put("text", "Cyclic read value");
            for (String nodeId : this.getBatchActions().keySet()) {
                this.addFragmentsForNodeTo(teEvent, nodeId, (Collection)this.getBatchActions().get(nodeId), (DataValue)this.getEvent().getValues().get(nodeId));
            }
            String topic = "te/device/" + this.getDeviceId().getValue() + "///e/" + this.getType();
            Gson gson = new GsonBuilder().create();
            MqttMessage message = new MqttMessage();
            String mqttString = gson.toJson(teEvent);
            message.setPayload(mqttString.getBytes());
            this.mqttClient.publish(topic, message);
        }
        catch (MqttException e) {
            this.alarmRepository.create(this.getDeviceId(), "opcuaMqttPublishFailed", CumulocitySeverities.MAJOR.name(), "Failed to publish MQTT message: " + e.getMessage());
            log.error("Failed to publish MQTT message: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void addFragmentsForNodeTo(Map<String, Object> teEvent, String nodeId, Collection<MappingAction> actions, DataValue dataValue) {
        for (MappingAction action : actions) {
            if (action instanceof EventCreation) {
                EventCreation eventCreation = (EventCreation)action;
                HashMap<Object, Object> fragment = new HashMap<Object, Object>();
                fragment.put("text", eventCreation.getText().replaceAll("\\$\\{value}", OpcuaSerializer.getInstance().toJson((Object)dataValue)));
                fragment.put("c8y_ua_SourceNodeId_" + nodeId, new HashMap());
                try {
                    TaskUtils.populateEventValueFragment(fragment, (DataValue)dataValue);
                }
                catch (JsonProcessingException jpe) {
                    log.error("Cannot parse event value to JSON");
                }
                TaskUtils.populateStaticFragments((MappingAction)eventCreation, fragment);
                teEvent.put(eventCreation.getType(), fragment);
                continue;
            }
            log.warn("Unsupported action type for ThinEdge event: {}", (Object)action.getClass().getSimpleName());
        }
    }

    public void setMqttClient(MqttClient mqttClient) {
        this.mqttClient = mqttClient;
    }

    public void setAlarmRepository(ThinEdgeAlarmRepository alarmRepository) {
        this.alarmRepository = alarmRepository;
    }
}

