/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.cyclicreader;

import com.cumulocity.opcua.client.gateway.connection.model.ServerDisconnectedEvent;
import com.cumulocity.opcua.client.gateway.cyclicreader.ReaderTask;
import com.cumulocity.opcua.client.gateway.cyclicreader.model.CyclicReadDefinition;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Component;

@Component
public class CyclicReadExecutor {
    private static final Logger log = LoggerFactory.getLogger(CyclicReadExecutor.class);
    @Autowired
    private ApplicationContext context;
    @Autowired
    @Qualifier(value="cyclicReadTaskScheduler")
    private ThreadPoolTaskScheduler scheduler;
    Map<CyclicReadDefinition, ScheduledFuture<?>> scheduledReads = new ConcurrentHashMap();

    public void addCyclicRead(CyclicReadDefinition read) {
        log.info("Adding cyclic read: " + String.valueOf(read));
        this.removeCyclicRead(read);
        ReaderTask readerTask = (ReaderTask)this.context.getBean(ReaderTask.class);
        readerTask.setCyclicReadDefinition(read);
        ScheduledFuture scheduledFuture = this.scheduler.scheduleAtFixedRate((Runnable)readerTask, read.getInterval());
        this.scheduledReads.put(read, scheduledFuture);
    }

    public void removeCyclicRead(CyclicReadDefinition read) {
        if (this.scheduledReads.containsKey(read)) {
            ScheduledFuture previous = (ScheduledFuture)this.scheduledReads.get(read);
            previous.cancel(false);
            this.scheduledReads.remove(read);
        }
    }

    public void removeAllCyclicReads() {
        log.info("Disabling all cyclic readers");
        Collection allScheduledReads = this.scheduledReads.values();
        allScheduledReads.forEach(scheduledFuture -> scheduledFuture.cancel(true));
        this.scheduledReads.clear();
    }

    @EventListener
    public void removeAllCyclicReadsOnServer(ServerDisconnectedEvent disconnectedEvent) {
        log.info("Server is disconnected, removing cyclic reads if any");
        Collection serverReads = this.scheduledReads.keySet().stream().filter(read -> disconnectedEvent.getServerIdentifier().getInventoryIdentifier().getValue().equals(read.getServerId())).collect(Collectors.toSet());
        serverReads.forEach(arg_0 -> this.removeCyclicRead(arg_0));
    }

    public int getScheduledReadsCount() {
        return this.scheduledReads.size();
    }

    public int getActiveThreads() {
        return this.scheduler.getActiveCount();
    }

    public double getAvgInterval() {
        if (this.scheduledReads.isEmpty()) {
            return 0.0;
        }
        double sum = 0.0;
        for (CyclicReadDefinition cyclicReadDefinition : this.scheduledReads.keySet()) {
            sum += (double)cyclicReadDefinition.getInterval();
        }
        return sum / (double)this.scheduledReads.size();
    }

    public void removeCyclicReads(@NotNull String serverId, @Nullable String deviceTypeId, @Nullable String rootNodeId) {
        LinkedList<CyclicReadDefinition> toRemove = new LinkedList<CyclicReadDefinition>();
        for (CyclicReadDefinition crd : this.scheduledReads.keySet()) {
            if (!this.matches(crd, serverId, deviceTypeId, rootNodeId)) continue;
            toRemove.add(crd);
        }
        for (CyclicReadDefinition crd : toRemove) {
            this.removeCyclicRead(crd);
        }
    }

    private boolean matches(CyclicReadDefinition crd, String serverId, String deviceTypeId, String rootNodeId) {
        if (!serverId.equals(crd.getServerId())) {
            return false;
        }
        if (deviceTypeId != null && !deviceTypeId.equals(crd.getDeviceTypeId())) {
            return false;
        }
        return rootNodeId == null || rootNodeId.equals(crd.getRootNodeId());
    }

    public Map<CyclicReadDefinition, ScheduledFuture<?>> getScheduledReads() {
        return this.scheduledReads;
    }
}

