/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.configuration;

import com.cumulocity.sdk.client.ProcessingMode;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class InventoryUpdateProcessingModeConfiguration {
    @Value(value="${gateway.platform.inventory.update.defaultProcessingMode:QUIESCENT}")
    private ProcessingMode defaultUpdateProcessingMode;
    @Value(value="${gateway.platform.inventory.update.gateway.processingMode:}")
    private ProcessingMode gatewayUpdateProcessingMode;
    @Value(value="${gateway.platform.inventory.update.server.processingMode:}")
    private ProcessingMode serverUpdateProcessingMode;
    @Value(value="${gateway.platform.inventory.update.valuemap.processingMode:}")
    private ProcessingMode valueMapUpdateProcessingMode;

    public ProcessingMode getDefaultUpdateProcessingMode() {
        return this.defaultUpdateProcessingMode;
    }

    public ProcessingMode getGatewayUpdateProcessingMode() {
        return Objects.isNull(this.gatewayUpdateProcessingMode) ? this.defaultUpdateProcessingMode : this.gatewayUpdateProcessingMode;
    }

    public ProcessingMode getServerUpdateProcessingMode() {
        return Objects.isNull(this.serverUpdateProcessingMode) ? this.defaultUpdateProcessingMode : this.serverUpdateProcessingMode;
    }

    public ProcessingMode getValueMapUpdateProcessingMode() {
        return Objects.isNull(this.valueMapUpdateProcessingMode) ? this.defaultUpdateProcessingMode : this.valueMapUpdateProcessingMode;
    }
}

