/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.addressspace.modelchange.service;

import c8y.ua.Node;
import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.NodeIds;
import com.cumulocity.opcua.client.Nodes;
import com.cumulocity.opcua.client.OpcuaClient;
import com.cumulocity.opcua.client.exception.OpcuaClientException;
import com.cumulocity.opcua.client.gateway.AddressSpaceCleaner;
import com.cumulocity.opcua.client.gateway.AddressSpaceScanner;
import com.cumulocity.opcua.client.gateway.ServerIdentifier;
import com.cumulocity.opcua.client.gateway.addressspace.exception.AddressSpaceInventorySyncException;
import com.cumulocity.opcua.client.gateway.addressspace.modelchange.model.ModelChangeEvent;
import com.cumulocity.opcua.client.gateway.addressspace.service.AddressSpaceDataStoreService;
import com.cumulocity.opcua.client.gateway.addressspace.service.AddressSpaceInventoryService;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.connection.model.AddressSpaceUpdatedEvent;
import com.cumulocity.opcua.common.repository.AddressSpaceRepository;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.ModelChangeStructureDataType;
import com.prosysopc.ua.stack.core.ModelChangeStructureVerbMask;
import com.prosysopc.ua.stack.core.SemanticChangeStructureDataType;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ModelChangeListenerService {
    private static final Logger log = LoggerFactory.getLogger(ModelChangeListenerService.class);
    public static final int INVENTORY_SYNC_TIMEOUT_IN_MINUTES = 60;
    private final Map<String, Object> locks = new ConcurrentHashMap();
    @Autowired
    private ConnectionManager connectionManager;
    @Autowired
    private AddressSpaceScanner addressSpaceScanner;
    @Autowired
    private AddressSpaceDataStoreService addressSpaceDataStoreService;
    @Autowired
    private AddressSpaceInventoryService addressSpaceInventoryService;
    @Autowired
    private AddressSpaceRepository addressSpaceRepository;
    @Autowired
    private AddressSpaceCleaner addressSpaceCleaner;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    @EventListener(value={ModelChangeEvent.class})
    public void handleModelChangeEvent(ModelChangeEvent event) {
        Optional client = this.connectionManager.getConnection(new ServerIdentifier(GId.asGId((String)event.getServerId())));
        if (!client.isPresent()) {
            log.error("Handing model change event failed. Client for server {} does not exist", (Object)event.getServerId());
            return;
        }
        Variant[] variants = event.getVariants();
        NodeId eventType = (NodeId)variants[0].asClass(NodeId.class, (Object)Identifiers.BaseEventType);
        try {
            log.debug("Model change event is received. {}", (Object)event);
            if (Identifiers.GeneralModelChangeEventType.equals((Object)eventType)) {
                this.handleGeneralModelChangeEvent((OpcuaClient)client.get(), event);
            } else if (Identifiers.SemanticChangeEventType.equals((Object)eventType)) {
                this.handleSemanticModelChangeEvent((OpcuaClient)client.get(), event);
            }
        }
        catch (Exception e) {
            log.error("Handing model change event failed", (Throwable)e);
        }
    }

    private void handleGeneralModelChangeEvent(OpcuaClient client, ModelChangeEvent event) throws OpcuaClientException {
        Variant[] variants = event.getVariants();
        ModelChangeStructureDataType[] modelChanges = (ModelChangeStructureDataType[])variants[1].asClass(ModelChangeStructureDataType[].class, (Object)new ModelChangeStructureDataType[0]);
        this.addressSpaceCleaner.recordAddressSpaceScan(event.getServerId());
        for (ModelChangeStructureDataType modelChange : modelChanges) {
            NodeId affectedNodeId = modelChange.getAffected();
            EnumSet modelChangeVerbs = ModelChangeStructureVerbMask.getSet((int)modelChange.getVerb().intValue());
            if (modelChangeVerbs.contains(ModelChangeStructureVerbMask.ReferenceAdded) || modelChangeVerbs.contains(ModelChangeStructureVerbMask.ReferenceDeleted)) {
                log.info("Reference {} detected. Affected node {} for server {}", new Object[]{modelChangeVerbs.contains(ModelChangeStructureVerbMask.ReferenceAdded) ? "addition" : "deletion", affectedNodeId, event.getServerId()});
                this.syncWithStartNode(client, affectedNodeId, event.getServerId());
                this.eventPublisher.publishEvent((Object)new AddressSpaceUpdatedEvent(ServerIdentifier.of((String)event.getServerId())));
                continue;
            }
            if (modelChangeVerbs.contains(ModelChangeStructureVerbMask.NodeAdded)) {
                log.info("Node addition detected. Affected node {} for server {}", (Object)affectedNodeId, (Object)event.getServerId());
                this.syncForNode(client, affectedNodeId, event.getServerId());
                this.eventPublisher.publishEvent((Object)new AddressSpaceUpdatedEvent(ServerIdentifier.of((String)event.getServerId())));
                continue;
            }
            if (modelChangeVerbs.contains(ModelChangeStructureVerbMask.NodeDeleted)) {
                log.info("Node deletion detected. Affected node {} for server {}", (Object)affectedNodeId, (Object)event.getServerId());
                if (client.doesNodeExist(affectedNodeId.toString())) {
                    this.syncForNode(client, affectedNodeId, event.getServerId());
                } else {
                    this.deleteNode(client, affectedNodeId, event.getServerId());
                }
                this.eventPublisher.publishEvent((Object)new AddressSpaceUpdatedEvent(ServerIdentifier.of((String)event.getServerId())));
                continue;
            }
            if (!modelChangeVerbs.contains(ModelChangeStructureVerbMask.DataTypeChanged)) continue;
            log.info("Data type change detected. Affected node {} for server {}", (Object)affectedNodeId, (Object)event.getServerId());
            this.updateNode(client, affectedNodeId, event.getServerId());
        }
    }

    private void handleSemanticModelChangeEvent(OpcuaClient client, ModelChangeEvent event) throws OpcuaClientException {
        SemanticChangeStructureDataType[] semanticChanges;
        Variant[] variants = event.getVariants();
        for (SemanticChangeStructureDataType semanticChange : semanticChanges = (SemanticChangeStructureDataType[])variants[1].asClass(SemanticChangeStructureDataType[].class, (Object)new SemanticChangeStructureDataType[0])) {
            NodeId affectedNodeId = semanticChange.getAffected();
            log.info("Semantic change detected. Affected node {} for server {}", (Object)affectedNodeId, (Object)event.getServerId());
            this.updateNode(client, affectedNodeId, event.getServerId());
        }
    }

    void syncWithStartNode(OpcuaClient client, NodeId startNodeId, String serverId) throws OpcuaClientException {
        Node startNode = Node.builder().nodeId(startNodeId.toString()).build();
        List startNodeAndAncestors = this.addressSpaceScanner.scanReverse(client, serverId, startNode);
        if (CollectionUtils.isEmpty((Collection)startNodeAndAncestors)) {
            return;
        }
        startNode = (Node)startNodeAndAncestors.get(0);
        List ancestors = startNodeAndAncestors.subList(1, startNodeAndAncestors.size());
        for (Node node : ancestors) {
            this.addressSpaceInventoryService.createOrUpdateNode(node, client.getNamespaceTable(), GId.asGId((String)serverId));
        }
        ConcurrentLinkedQueue queue = new ConcurrentLinkedQueue(this.addressSpaceScanner.scan(client, serverId, startNode, false));
        try {
            this.addressSpaceInventoryService.syncAndStoreAddressSpace(queue, startNode, client.getNamespaceTable(), GId.asGId((String)serverId), 60);
        }
        catch (AddressSpaceInventorySyncException | InterruptedException e) {
            log.error("Could not synchronize address space inventory objects for server {}", (Object)serverId, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncForNode(OpcuaClient client, NodeId affectedNodeId, String serverId) throws OpcuaClientException {
        Node affectedNode = Node.builder().nodeId(affectedNodeId.toString()).build();
        List startNodeAndAncestors = this.addressSpaceScanner.scanReverse(client, serverId, affectedNode);
        if (CollectionUtils.isEmpty((Collection)startNodeAndAncestors)) {
            return;
        }
        Iterator iterator = this.acquireLockForServer(serverId);
        synchronized (iterator) {
            this.addressSpaceDataStoreService.storeAddressSpace(Arrays.asList((Node)startNodeAndAncestors.get(0)), serverId);
        }
        for (Node node : startNodeAndAncestors) {
            this.addressSpaceInventoryService.createOrUpdateNode(node, client.getNamespaceTable(), GId.asGId((String)serverId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNode(OpcuaClient client, NodeId affectedNodeId, String serverId) throws OpcuaClientException {
        Node affectedNode = Node.builder().nodeId(affectedNodeId.toString()).build();
        List startNodeAndAncestors = client.scanReverse(affectedNode);
        if (CollectionUtils.isEmpty((Collection)startNodeAndAncestors)) {
            return;
        }
        affectedNode = (Node)startNodeAndAncestors.get(0);
        Nodes.useNsUriForNode((Node)affectedNode, (NamespaceTable)client.getNamespaceTable());
        Object object = this.acquireLockForServer(serverId);
        synchronized (object) {
            this.addressSpaceDataStoreService.updateNodeInAddressSpace(affectedNode, serverId);
        }
        this.addressSpaceInventoryService.updateNode(affectedNode, client.getNamespaceTable(), GId.asGId((String)serverId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteNode(OpcuaClient client, NodeId affectedNodeId, String serverId) {
        String nodeIdWithNsUri = NodeIds.toNodeIdWithNsUri((NamespaceTable)client.getNamespaceTable(), (String)affectedNodeId.toString());
        Object object = this.acquireLockForServer(serverId);
        synchronized (object) {
            this.addressSpaceDataStoreService.deleteNodeFromAddressSpace(nodeIdWithNsUri, serverId);
        }
        this.addressSpaceInventoryService.deleteNode(nodeIdWithNsUri, null, GId.asGId((String)serverId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object acquireLockForServer(String serverId) {
        Map map = this.locks;
        synchronized (map) {
            if (this.locks.containsKey(serverId)) {
                return this.locks.get(serverId);
            }
            Object lock = new Object();
            this.locks.put(serverId, lock);
            return lock;
        }
    }
}

