/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.valuemap;

import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.gateway.configuration.InventoryUpdateProcessingModeConfiguration;
import com.cumulocity.opcua.common.repository.InventoryRepository;
import com.cumulocity.opcua.common.valuemap.PlatformOpcuaValue;
import com.cumulocity.opcua.common.valuemap.ServerValueMap;
import com.cumulocity.opcua.common.valuemap.ValueMapRepositoryImpl;
import com.cumulocity.rest.representation.identity.ExternalIDRepresentation;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.cumulocity.sdk.client.SDKException;
import com.cumulocity.sdk.client.identity.IdentityApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class DeviceGatewayValueManagerImpl
extends ValueMapRepositoryImpl {
    private static final Logger log = LoggerFactory.getLogger(DeviceGatewayValueManagerImpl.class);
    @Autowired
    IdentityApi identityApi;
    @Autowired
    @Qualifier(value="pmAwareInventoryRepository")
    InventoryRepository inventoryApi;
    @Autowired
    private InventoryUpdateProcessingModeConfiguration processingModeConfiguration;

    public ManagedObjectRepresentation getManagedObjectForServerMap(String serverId) {
        try {
            return this.findServerValueMapInInventory(serverId);
        }
        catch (SDKException e) {
            if (e.getHttpStatus() == 404) {
                log.debug("No Server value map managed object found, creating one");
                ManagedObjectRepresentation mo = new ManagedObjectRepresentation();
                mo.setType("c8yInternal_opcuaValueMap");
                mo.set((Object)30, "lifetime");
                ManagedObjectRepresentation result = this.inventoryApi.create(mo);
                ExternalIDRepresentation externalIDRepresentation = new ExternalIDRepresentation();
                externalIDRepresentation.setManagedObject(result);
                externalIDRepresentation.setType("valueMapForServer");
                externalIDRepresentation.setExternalId(serverId);
                this.identityApi.create(externalIDRepresentation);
                log.debug("Successfully created value map object for server {} with id {}", (Object)serverId, (Object)result.getId().toString());
                return result;
            }
            throw e;
        }
    }

    public void updateValueMap(String serverId, ServerValueMap serverValueMap) {
        GId serverMapMoId = this.getManagedObjectForServerMap(serverId).getId();
        ManagedObjectRepresentation valueMapMo = new ManagedObjectRepresentation();
        valueMapMo.setType("c8yInternal_opcuaValueMap");
        valueMapMo.setId(serverMapMoId);
        serverValueMap.forEach((key, fragmentValue) -> {
            String fragmentName = "opcuaVal_" + key;
            valueMapMo.set((Object)PlatformOpcuaValue.toMap((PlatformOpcuaValue)fragmentValue), fragmentName);
        });
        valueMapMo.setProperty("lifetime", (Object)serverValueMap.getLifeTime());
        this.inventoryApi.update(valueMapMo, this.processingModeConfiguration.getValueMapUpdateProcessingMode());
        log.info("Successfully updated value map mo {} for server ID{}", (Object)serverMapMoId.getValue(), (Object)serverId);
    }
}

