/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.subscription;

import com.cumulocity.opcua.client.gateway.mappings.model.DataMappingParameters;
import com.cumulocity.opcua.client.gateway.subscription.SubscriptionService;
import com.cumulocity.opcua.client.gateway.subscription.model.BaseSubscriptionData;
import com.cumulocity.opcua.client.gateway.subscription.model.SubscribedItem;
import com.cumulocity.opcua.client.gateway.subscription.model.SubscribedItemId;
import com.cumulocity.opcua.client.gateway.subscription.model.SubscriptionData;
import com.cumulocity.opcua.client.gateway.subscription.repository.SubscriptionRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="nonSubscriptionService")
public class NoneSubscriptionService
implements SubscriptionService {
    private static final Logger log = LoggerFactory.getLogger(NoneSubscriptionService.class);
    @Autowired
    private SubscriptionRepository subscriptionRepository;

    public <T extends BaseSubscriptionData> void applySubscriptions(String serverId, T subscriptionData) {
        if (!(subscriptionData instanceof SubscriptionData)) {
            return;
        }
        ArrayList<SubscribedItem> items = new ArrayList<SubscribedItem>();
        for (Map.Entry entry : ((SubscriptionData)subscriptionData).getNodeSubscriptions().entrySet()) {
            if (!this.isNoneSubscription((DataMappingParameters)entry.getValue())) continue;
            SubscribedItem subscribedItem = SubscribedItem.builder().deviceTypeId(subscriptionData.getDeviceTypeId()).rootNodeId(subscriptionData.getRootNodeId()).subscriptionType(this.getSubscriptionType()).subscribedItemId(new SubscribedItemId(serverId, subscriptionData.getRootNodeId(), (String)entry.getKey(), subscriptionData.getDeviceTypeId())).mappedActions(((DataMappingParameters)entry.getValue()).getMappingActions()).build();
            items.add(subscribedItem);
        }
        this.subscriptionRepository.addSubscribedItems(items);
    }

    public void removeSubscriptions(String serverId, String deviceTypeId, String rootNodeId) {
        this.subscriptionRepository.removeSubscribedNode(serverId, deviceTypeId, rootNodeId, this.getSubscriptionType());
    }

    public void removeSubscriptions(String serverId, Collection<String> deviceTypeIds) {
        this.subscriptionRepository.removeSubscribedItemsForDeviceTypes(serverId, deviceTypeIds, this.getSubscriptionType());
    }

    public void removeServerSubscriptions(String serverId) {
        this.subscriptionRepository.removeServerSubscriptions(serverId, this.getSubscriptionType());
    }

    public String getSubscriptionType() {
        return "None";
    }

    private boolean isNoneSubscription(DataMappingParameters mappingParameters) {
        return Objects.nonNull(mappingParameters.getSubscriptionConfig()) && this.getSubscriptionType().equalsIgnoreCase(mappingParameters.getSubscriptionConfig().getType());
    }
}

