/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.ssh;

import c8y.ua.ClientConfig;
import c8y.ua.data.DeviceTypeMappedNode;
import com.cumulocity.model.util.ExtensibilityConverter;
import com.cumulocity.opcua.client.exception.OpcuaClientException;
import com.cumulocity.opcua.client.gateway.GatewayManager;
import com.cumulocity.opcua.client.gateway.ServerIdentifier;
import com.cumulocity.opcua.client.gateway.debug.DebugHelper;
import com.cumulocity.opcua.client.gateway.exception.ServerNotConnectedException;
import com.cumulocity.opcua.client.gateway.mappings.RegularDeviceTypeMatchingService;
import com.cumulocity.opcua.client.gateway.subscription.DeviceTypeConverter;
import com.cumulocity.opcua.common.model.mapping.DeviceType;
import com.cumulocity.opcua.common.repository.InventoryRepository;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.cumulocity.sdk.client.QueryParam;
import com.cumulocity.sdk.client.inventory.InventoryFilter;
import com.cumulocity.sdk.client.inventory.PagedManagedObjectCollectionRepresentation;
import com.github.fonimus.ssh.shell.SshShellHelper;
import com.github.fonimus.ssh.shell.commands.SshShellComponent;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.standard.ShellCommandGroup;
import org.springframework.shell.standard.ShellMethod;

@SshShellComponent
@ShellCommandGroup(value="Configuration")
public class SshConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(SshConfigurationService.class);
    @Autowired
    private SshShellHelper helper;
    @Autowired
    private GatewayManager gatewayManager;
    @Autowired
    private RegularDeviceTypeMatchingService deviceTypeMatchingService;
    @Autowired
    private InventoryRepository inventoryRepository;
    @Autowired
    private DebugHelper debugHelper;

    @ShellMethod(value="Add OPCUA server to gateway")
    public String addServer() {
        boolean autoscan;
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setServerUrl("opc.tcp://localhost:53530/OPCUA/SimulationServer");
        String value = this.helper.read("Enter server address [" + clientConfig.getServerUrl() + "]: ");
        if (value != null && !value.trim().isEmpty()) {
            clientConfig.setServerUrl(value);
        }
        this.helper.print("Server address set to: " + clientConfig.getServerUrl());
        clientConfig.setSecurityMode("NONE");
        this.helper.print("Available security modes: ");
        this.helper.print("  1 - NONE");
        this.helper.print("  2 - BASIC128RSA15_SIGN");
        this.helper.print("  3 - BASIC128RSA15_SIGN_ENCRYPT");
        this.helper.print("  4 - BASIC256_SIGN");
        this.helper.print("  5 - BASIC256_SIGN_ENCRYPT");
        this.helper.print("  6 - BASIC128RSA15_SIGN");
        this.helper.print("  7 - BASIC256SHA256_SIGN_ENCRYPT");
        switch (value = this.helper.read("Choose security mode [1-7]: ")) {
            case "2": {
                clientConfig.setSecurityMode("BASIC128RSA15_SIGN");
                break;
            }
            case "3": {
                clientConfig.setSecurityMode("BASIC128RSA15_SIGN_ENCRYPT");
                break;
            }
            case "4": {
                clientConfig.setSecurityMode("BASIC256_SIGN");
                break;
            }
            case "5": {
                clientConfig.setSecurityMode("BASIC256_SIGN_ENCRYPT");
                break;
            }
            case "6": {
                clientConfig.setSecurityMode("BASIC128RSA15_SIGN");
                break;
            }
            case "7": {
                clientConfig.setSecurityMode("BASIC256SHA256_SIGN_ENCRYPT");
                break;
            }
        }
        this.helper.print("Security mode set to: " + clientConfig.getSecurityMode());
        this.helper.print("Available user authentication modes: ");
        this.helper.print("  1 - NONE");
        this.helper.print("  2 - User name and password");
        this.helper.print("  3 - X509 certificate in JKS keystore");
        switch (value = this.helper.read("Choose security mode [1-7]: ")) {
            case "1": {
                break;
            }
            case "2": {
                clientConfig.setUserName(this.helper.read("Username (optional): "));
                clientConfig.setUserPassword(this.helper.read("Password (optional): "));
                break;
            }
            case "3": {
                clientConfig.setKeystoreBinaryId(this.helper.read("Cumulocity binary ID of the keystore: "));
                clientConfig.setKeystorePass(this.helper.read("Keystore password: "));
                clientConfig.setCertificatePass(this.helper.read("Certificate password: "));
                break;
            }
        }
        String nodeId = this.helper.read("Enter default node ids [or leave empty for root node]: ");
        if (nodeId != null && !nodeId.trim().isEmpty()) {
            List<String> strings = Arrays.asList(nodeId.replaceAll("\\s", "").split(","));
            Set nodeIds = strings.stream().filter(s -> !Strings.isNullOrEmpty((String)s)).collect(Collectors.toSet());
            clientConfig.setPartialAddressScanNodeIds(nodeIds);
        }
        if (autoscan = this.helper.confirm("Start an address scan immediately?", new String[0])) {
            clientConfig.setAutoScanAddressSpace(Boolean.valueOf(true));
        }
        String name = "";
        while (name.trim().isEmpty()) {
            name = this.helper.read("Provide a name for the server: ");
        }
        this.helper.printInfo("Validate configuration...");
        this.helper.printInfo(clientConfig.toString());
        boolean correct = this.helper.confirm("Is this configuration correct?", new String[0]);
        if (!correct) {
            return "Operation canceled";
        }
        try {
            this.helper.printInfo("Adding server...");
            ManagedObjectRepresentation deviceMo = this.gatewayManager.addChildDeviceToGateway(clientConfig, name);
            this.helper.printSuccess("Device has been created!");
            return "New server device ID: " + deviceMo.getId().getValue();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.helper.printError("An error occurred: " + e.getMessage());
            return "See logs for more details";
        }
    }

    @ShellMethod(value="Check matching device types")
    public String checkDT() {
        List deviceTypes = this.getAllDeviceTypes();
        for (ServerIdentifier si : this.gatewayManager.getGatewayDetails().getServerIdentifiers()) {
            try {
                Collection matchingNodes = this.deviceTypeMatchingService.matches(si.getInventoryIdentifier().getValue(), deviceTypes);
                for (DeviceTypeMappedNode node : matchingNodes) {
                    this.helper.printInfo("===== Mappings for " + node.getNodeId());
                    this.helper.printInfo(node.getDeviceTypeId());
                }
            }
            catch (OpcuaClientException | ServerNotConnectedException e) {
                log.error(e.getMessage(), e);
            }
        }
        return "done!";
    }

    @ShellMethod(value="Crash Heap until it is full to provoke an out of memory exception")
    public void fillHeap() throws InterruptedException {
        this.debugHelper.crashHeap();
    }

    private List<DeviceType> getAllDeviceTypes() {
        InventoryFilter deviceTypeFilter = new InventoryFilter().byType("c8y_OpcuaDeviceType");
        return StreamSupport.stream(((PagedManagedObjectCollectionRepresentation)this.inventoryRepository.getManagedObjectsByFilter(deviceTypeFilter).get(1000, new QueryParam[0])).allPages().spliterator(), false).filter(mo -> mo.hasProperty(ExtensibilityConverter.classToStringRepresentation(DeviceType.class))).map(arg_0 -> this.toDeviceType(arg_0)).collect(Collectors.toList());
    }

    private DeviceType toDeviceType(ManagedObjectRepresentation managedObject) {
        DeviceType deviceType = (DeviceType)managedObject.get(DeviceType.class);
        if (!Objects.isNull(deviceType)) {
            deviceType.setId(managedObject.getId().getValue());
            DeviceTypeConverter.unEscapeHtml((DeviceType)deviceType);
        }
        return deviceType;
    }
}

