/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.platform.repository.strategy;

import com.cumulocity.opcua.client.gateway.platform.repository.BaseQueuedRepository;
import com.cumulocity.opcua.client.gateway.platform.repository.util.ElementQueueOperation;
import com.cumulocity.rest.representation.AbstractExtensibleRepresentation;
import com.cumulocity.sdk.client.SDKException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFlushExecutor<T extends AbstractExtensibleRepresentation, Z> {
    private static final Logger log = LoggerFactory.getLogger(BaseFlushExecutor.class);
    protected BaseQueuedRepository<T, Z> baseQueuedRepository;
    protected ElementQueueOperation<T, Z> elementQueueOperation;

    public BaseFlushExecutor(BaseQueuedRepository<T, Z> baseQueuedRepository, ElementQueueOperation<T, Z> elementQueueOperation) {
        this.baseQueuedRepository = baseQueuedRepository;
        this.elementQueueOperation = elementQueueOperation;
    }

    protected void handleException(Exception e, Z element) {
        String repoName = this.baseQueuedRepository.getName();
        log.error("{}: Couldn't create the element! {}", (Object)repoName, (Object)e.getMessage());
        log.debug(e.getMessage(), (Throwable)e);
        log.info("{}: Adding element back to queue", (Object)repoName);
        this.elementQueueOperation.addToQueueWithSourceCheck(this.baseQueuedRepository.getQueue(), element);
    }

    protected void handleException(SDKException e, Z element) {
        String repoName = this.baseQueuedRepository.getName();
        log.error("{} : Couldn't create the element! {}", (Object)repoName, (Object)e.getMessage());
        log.debug(e.getMessage(), (Throwable)e);
        if (e.getHttpStatus() == 403 || e.getHttpStatus() == 422) {
            log.warn("{}: A {} exception catched and might be a sign of a deleted source", (Object)repoName, (Object)e.getHttpStatus());
            log.warn("{}: Checking source validity", (Object)repoName);
            this.elementQueueOperation.addToQueueWithSourceAvailability(this.baseQueuedRepository.getQueue(), element);
        } else {
            log.error("{}: SDKException response code: {}", (Object)repoName, (Object)e.getHttpStatus());
            log.error("{}: Internal error, adding element back to queue", (Object)repoName);
            this.elementQueueOperation.addToQueueWithSourceCheck(this.baseQueuedRepository.getQueue(), element);
        }
    }
}

