/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.operation.handler.base;

import c8y.ua.command.BaseOperation;
import com.cumulocity.model.idtype.GId;
import com.cumulocity.opcua.client.OpcuaClient;
import com.cumulocity.opcua.client.gateway.GatewayManager;
import com.cumulocity.opcua.client.gateway.ServerIdentifier;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.operation.handler.base.HandleInternalResult;
import com.cumulocity.opcua.client.gateway.operation.handler.base.OperationHandler;
import com.cumulocity.opcua.client.gateway.operation.handler.base.UAOperationNodeValidator;
import com.cumulocity.rest.representation.inventory.ManagedObjectReferenceCollectionRepresentation;
import com.cumulocity.rest.representation.inventory.ManagedObjectReferenceRepresentation;
import com.cumulocity.rest.representation.inventory.ManagedObjectRepresentation;
import com.cumulocity.sdk.client.QueryParam;
import com.cumulocity.sdk.client.devicecontrol.DeviceControlApi;
import com.cumulocity.sdk.client.inventory.InventoryApi;
import com.cumulocity.sdk.client.inventory.InventoryParam;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UAOperationHandler<T extends BaseOperation>
extends OperationHandler<T> {
    private static final Logger log = LoggerFactory.getLogger(UAOperationHandler.class);
    protected final ConnectionManager connectionManager;
    protected final GatewayManager gatewayManager;
    protected final InventoryApi inventoryApi;
    protected final UAOperationNodeValidator nodeValidator;

    public UAOperationHandler(GatewayManager gatewayManager, ConnectionManager connectionManager, Class<T> supportedOperationType, DeviceControlApi deviceControlApi, InventoryApi inventoryApi, UAOperationNodeValidator nodeValidator) {
        super(deviceControlApi, supportedOperationType);
        this.gatewayManager = gatewayManager;
        this.connectionManager = connectionManager;
        this.inventoryApi = inventoryApi;
        this.nodeValidator = nodeValidator;
    }

    protected Optional<OpcuaClient> resolveClient(T operation) {
        Optional connection = this.connectionManager.getConnection(new ServerIdentifier(operation.getDeviceId()));
        if (connection.isPresent()) {
            log.info("Operation directly assigned to OPC UA Server: " + String.valueOf(operation.getDeviceId()));
            return connection;
        }
        log.debug("Check if operation is for a child device of a OPC UA Server, id = {}", (Object)operation.getDeviceId());
        ManagedObjectRepresentation childDeviceMangedObject = this.inventoryApi.get(GId.asGId((Object)operation.getDeviceId()), new QueryParam[]{InventoryParam.withParents()});
        if (childDeviceMangedObject == null) {
            log.warn("OPC UA Server or device with id " + String.valueOf(operation.getDeviceId()) + "not found in inventory!");
            return Optional.empty();
        }
        ManagedObjectReferenceCollectionRepresentation deviceParents = childDeviceMangedObject.getDeviceParents();
        for (ManagedObjectReferenceRepresentation deviceParent : deviceParents) {
            String OPCUAServerId = deviceParent.getManagedObject().getId().getValue();
            log.debug("Parent fetched, connected OPC UA Server: " + OPCUAServerId);
            connection = this.connectionManager.getConnection(new ServerIdentifier(GId.asGId((String)OPCUAServerId)));
            log.debug("Connected OPC UA Server found: {}, with id: {}", (Object)connection.isPresent(), (Object)OPCUAServerId);
            if (!connection.isPresent()) continue;
            log.info("Device operation forwarded to OPC UA Server: {}", (Object)OPCUAServerId);
            if (this.nodeValidator.isValidateDeviceOperationNodes()) {
                this.nodeValidator.validateNodes(this.getQueryNodes(operation), operation.getDeviceId(), OPCUAServerId, ((OpcuaClient)connection.get()).getNamespaceTable());
            }
            return connection;
        }
        log.warn("No connected OPC UA Server found!");
        return Optional.empty();
    }

    public Optional<String> getOPCUAServerId(T operation) {
        Optional connection = this.connectionManager.getConnection(new ServerIdentifier(operation.getDeviceId()));
        if (connection.isPresent()) {
            return Optional.ofNullable(operation.getDeviceId().getValue());
        }
        ManagedObjectRepresentation childDeviceMangedObject = this.inventoryApi.get(GId.asGId((Object)operation.getDeviceId()), new QueryParam[]{InventoryParam.withParents()});
        if (childDeviceMangedObject == null) {
            return Optional.empty();
        }
        ManagedObjectReferenceCollectionRepresentation deviceParents = childDeviceMangedObject.getDeviceParents();
        for (ManagedObjectReferenceRepresentation deviceParent : deviceParents) {
            connection = this.connectionManager.getConnection(new ServerIdentifier(deviceParent.getManagedObject().getId()));
            if (!connection.isPresent()) continue;
            return Optional.ofNullable(deviceParent.getManagedObject().getId().getValue());
        }
        return Optional.empty();
    }

    protected HandleInternalResult failWithReason(String reason) {
        HandleInternalResult result = new HandleInternalResult();
        result.setSuccessful(false);
        result.setFailureReason(reason);
        return result;
    }

    protected abstract Set<String> getQueryNodes(T var1);
}

