/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.operation.handler;

import c8y.ua.command.WriteValue;
import c8y.ua.data.RangedValue;
import com.cumulocity.opcua.client.gateway.GatewayManager;
import com.cumulocity.opcua.client.gateway.connection.ConnectionManager;
import com.cumulocity.opcua.client.gateway.operation.handler.base.BaseWriteOperationHandler;
import com.cumulocity.opcua.client.gateway.operation.handler.base.UAOperationNodeValidator;
import com.cumulocity.opcua.client.model.WriteData;
import com.cumulocity.opcua.client.serialization.OpcuaSerializer;
import com.cumulocity.sdk.client.devicecontrol.DeviceControlApi;
import com.cumulocity.sdk.client.inventory.InventoryApi;
import com.prosysopc.ua.stack.core.Attributes;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WriteValueOperationHandler
extends BaseWriteOperationHandler<WriteValue> {
    @Autowired
    public WriteValueOperationHandler(GatewayManager gatewayManager, ConnectionManager connectionManager, DeviceControlApi deviceControlApi, OpcuaSerializer serializer, InventoryApi inventoryApi, UAOperationNodeValidator nodeValidator) {
        super(gatewayManager, connectionManager, WriteValue.class, deviceControlApi, serializer, inventoryApi, nodeValidator);
    }

    protected WriteData getWriteData(WriteValue operation) {
        WriteData writeData = new WriteData();
        for (Map.Entry entry : operation.getValues().entrySet()) {
            RangedValue rangedValue = new RangedValue(((RangedValue)entry.getValue()).getRanges(), ((RangedValue)entry.getValue()).getValue());
            writeData.addRangedAttributeValue((String)entry.getKey(), String.valueOf(Attributes.Value.longValue()), rangedValue);
        }
        return writeData;
    }

    protected Set<String> getQueryNodes(WriteValue operation) {
        return operation.getValues().keySet();
    }
}

