/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappingsexecution.tasks;

import com.cumulocity.model.event.CumulocitySeverities;
import com.cumulocity.opcua.client.gateway.mappingsexecution.model.BaseDataValueEvent;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.BaseTask;
import com.cumulocity.opcua.client.gateway.mappingsexecution.tasks.TaskUtils;
import com.cumulocity.opcua.client.gateway.platform.repository.ThinEdgeAlarmRepository;
import com.cumulocity.opcua.common.model.mapping.action.EventCreation;
import com.cumulocity.opcua.common.model.mapping.action.MappingAction;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ThinEdgeEventCreationTask
extends BaseTask {
    private static final Logger log = LoggerFactory.getLogger(ThinEdgeEventCreationTask.class);
    private EventCreation eventCreation;
    @Autowired
    private MqttClient mqttClient;
    @Autowired
    private ThinEdgeAlarmRepository alarmRepository;

    public void run() {
        try {
            if (this.isDataValueBad()) {
                return;
            }
            String topic = "te/device/" + this.getSource().getId().getValue() + "///e/" + this.eventCreation.getType();
            Gson gson = new GsonBuilder().create();
            MqttMessage message = new MqttMessage();
            String mqttString = gson.toJson((Object)this.buildThinEdgeEvent());
            message.setPayload(mqttString.getBytes());
            this.mqttClient.publish(topic, message);
        }
        catch (MqttException e) {
            this.alarmRepository.create(this.getDeviceId(), "opcuaMqttPublishFailed", CumulocitySeverities.MAJOR.name(), "Failed to publish MQTT message: " + e.getMessage());
            log.error("Failed to publish MQTT message: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (JsonProcessingException jpe) {
            log.error("Cannot parse event value to JSON");
        }
    }

    private Map<String, Object> buildThinEdgeEvent() throws JsonProcessingException {
        BaseDataValueEvent event = this.getEvent();
        log.debug("Creating event for " + event.getServerId() + ":" + event.getNodeId() + " ## " + String.valueOf(this.eventCreation));
        String valueAsString = this.getValueAsJsonString();
        HashMap<String, Object> teEvent = new HashMap<String, Object>();
        teEvent.put("time", this.getDateTimeWithFallBack(event).toString());
        teEvent.put("text", this.eventCreation.getText().replaceAll("\\$\\{value}", valueAsString));
        teEvent.put("c8y_ua_SourceNodeId_" + event.getNodeId(), new HashMap());
        TaskUtils.populateEventValueFragment(teEvent, (DataValue)event.getValue());
        TaskUtils.populateStaticFragments((MappingAction)this.eventCreation, teEvent);
        return teEvent;
    }

    public void setEventCreation(EventCreation eventCreation) {
        this.eventCreation = eventCreation;
    }

    public void setMqttClient(MqttClient mqttClient) {
        this.mqttClient = mqttClient;
    }

    public void setAlarmRepository(ThinEdgeAlarmRepository alarmRepository) {
        this.alarmRepository = alarmRepository;
    }
}

