/*
 * Decompiled with CFR 0.152.
 */
package com.cumulocity.opcua.client.gateway.mappingsexecution.tasks;

import c8y.ua.data.C8YDataValue;
import com.cumulocity.opcua.client.serialization.OpcuaSerializer;
import com.cumulocity.opcua.common.model.mapping.action.MappingAction;
import com.cumulocity.opcua.common.validation.ValueLimitsValidator;
import com.cumulocity.rest.representation.AbstractExtensibleRepresentation;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.Variant;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class TaskUtils {
    public static Long getTimeStampOrNull(DateTime dateTime) {
        return Objects.nonNull(dateTime) ? Long.valueOf(dateTime.getTimeInMillis()) : null;
    }

    public static void populateStaticFragments(MappingAction mappingAction, AbstractExtensibleRepresentation target) {
        if (!CollectionUtils.isEmpty((Collection)mappingAction.getStaticFragments())) {
            mappingAction.getStaticFragments().forEach(fragment -> target.set(Collections.emptyMap(), fragment));
        }
    }

    public static void populateStaticFragments(MappingAction mappingAction, Map<String, Object> target) {
        if (!CollectionUtils.isEmpty((Collection)mappingAction.getStaticFragments())) {
            mappingAction.getStaticFragments().forEach(fragment -> target.put((String)fragment, Collections.emptyMap()));
        }
    }

    public static void populateEventValueFragment(Map<String, Object> event, DataValue dataValue) throws JsonProcessingException {
        Long sourceTimestamp = TaskUtils.getTimeStampOrNull((DateTime)dataValue.getSourceTimestamp());
        Long serverTimestamp = TaskUtils.getTimeStampOrNull((DateTime)dataValue.getServerTimestamp());
        C8YDataValue c8YDataValue = C8YDataValue.builder().statusCode((long)dataValue.getStatusCode().getValue().intValue()).serverTimestamp(serverTimestamp).sourceTimestamp(sourceTimestamp).value(TaskUtils.getVariantValueAsMap((Variant)dataValue.getValue())).build();
        event.put("c8y_DataValue", c8YDataValue);
    }

    public static Map<String, Object> getVariantValueAsMap(Variant variant) throws JsonProcessingException {
        Variant variantToSerialize = variant;
        ObjectMapper objectMapper = new ObjectMapper();
        if (variant.getValue() != null && NumberUtils.isCreatable((String)variant.getValue().toString())) {
            try {
                BigDecimal value = ValueLimitsValidator.readNumericValue((Object)variant.getValue());
                variantToSerialize = new Variant((Object)value);
            }
            catch (NumberFormatException value) {
                // empty catch block
            }
        }
        String variantValueAsString = OpcuaSerializer.getInstance().toJson((Object)variantToSerialize);
        return (Map)objectMapper.readValue(variantValueAsString, TreeMap.class);
    }
}

